/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 缴费库合并推送参数
 * @author huyc
 * @date 2023-2-10 10:01:22
 */
@Data
public class TPaymentInfoPushVo implements Serializable {

	/**
	 * 主键
	 */
	@Schema(description ="主键")
	private String id;
	/**
	 * 主键拼接
	 */
	@Schema(description ="主键拼接")
	private String ids;
	/**
	 * 员工姓名
	 */
	@ExcelAttribute(name = "员工姓名" )
	@Schema(description ="员工姓名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工姓名")
	private String empName;

	/**
	 * 身份证号
	 */
	@ExcelAttribute(name = "身份证号" )
	@Schema(description ="身份证号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证号")
	private String empIdcard;

	/**
	 * 客户名称
	 */
	@ExcelAttribute(name = "客户名称" )
	@Schema(description ="客户名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("客户名称")
	private String unitName;

	/**
	 * 项目名称
	 */
	@ExcelAttribute(name = "项目名称" )
	@Schema(description ="项目名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目名称")
	private String settleDomainName;

	/**
	 * 项目编码
	 */
	@ExcelAttribute(name = "项目编码", maxLength = 50)
	@Schema(description = "项目编码" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目编码" )
	private String settleDomainCode;

	/**
	 * 社保户
	 */
	@ExcelAttribute(name = "社保户" )
	@Schema(description ="社保户")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保户")
	private String socialHousehold;

	/**
	 * 社保缴纳地
	 */
	@ExcelAttribute(name = "社保缴纳地" )
	@Schema(description ="社保缴纳地")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保缴纳地")
	private String socialPayAddr;

	/**
	 * 社保缴纳月份
	 */
	@ExcelAttribute(name = "社保缴纳月份")
	@Schema(description ="社保缴纳月份")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保缴纳月份")
	private String socialPayMonth;

	/**
	 * 社保生成月份
	 */
	@ExcelAttribute(name = "社保生成月份")
	@Schema(description ="社保生成月份")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保生成月份")
	private String socialCreateMonth;

	/**
	 * 总合计
	 */
	@ExcelAttribute(name = "总合计" )
	@Schema(description ="总合计")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("总合计")
	private BigDecimal sumAll;

	/**
	 * 社保合计
	 */
	@ExcelAttribute(name = "社保合计" )
	@Schema(description ="社保合计")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保合计")
	private BigDecimal socialSum;

	/**
	 * 单位社保合计
	 */
	@ExcelAttribute(name = "单位社保合计" )
	@Schema(description ="单位社保合计")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位社保合计")
	private BigDecimal unitSocialSum;

	/**
	 * 个人社保合计
	 */
	@ExcelAttribute(name = "个人社保合计" )
	@Schema(description ="个人社保合计")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人社保合计")
	private BigDecimal socialSecurityPersonalSum;

	/**
	 * 单位社保补缴利息
	 */
	@ExcelAttribute(name = "单位社保补缴利息"  )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位社保补缴利息")
	private BigDecimal companyAccrual;
	/**
	 * 个人社保补缴利息
	 */
	@ExcelAttribute(name = "个人社保补缴利息"  )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人社保补缴利息")
	private BigDecimal personalAccrual;
	/**
	 * 单位养老金额
	 */
	@ExcelAttribute(name = "单位养老金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位养老金额")
	private BigDecimal unitPensionMoney;
	/**
	 * 单位医疗金额
	 */
	@ExcelAttribute(name = "单位医疗金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位医疗金额")
	private BigDecimal unitMedicalMoney;
	/**
	 * 单位失业金额
	 */
	@ExcelAttribute(name = "单位失业金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位失业金额")
	private BigDecimal unitUnemploymentMoney;
	/**
	 * 单位工伤金额
	 */
	@ExcelAttribute(name = "单位工伤金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位工伤金额")
	private BigDecimal unitInjuryMoney;
	/**
	 * 单位生育金额
	 */
	@ExcelAttribute(name = "单位生育金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位生育金额")
	private BigDecimal unitBirthMoney;
	/**
	 * 单位大病金额
	 */
	@ExcelAttribute(name = "单位大病金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位大病金额")
	private BigDecimal unitBigmailmentMoney;
	/**
	 * 个人养老金额
	 */
	@ExcelAttribute(name = "个人养老金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人养老金额")
	private BigDecimal personalPensionMoney;
	/**
	 * 个人医疗金额
	 */
	@ExcelAttribute(name = "个人医疗金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人医疗金额")
	private BigDecimal personalMedicalMoney;
	/**
	 * 个人失业金额
	 */
	@ExcelAttribute(name = "个人失业金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人失业金额")
	private BigDecimal personalUnemploymentMoney;
	/**
	 * 个人大病金额
	 */
	@ExcelAttribute(name = "个人大病金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人大病金额")
	private BigDecimal personalBigmailmentMoney;

	/**
	 * 社保创建人姓名
	 */
	@ExcelAttribute(name = "社保创建人姓名")
	@Schema(description = "社保创建人姓名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保创建人姓名")
	private String createName;
	/**
	 * 创建时间
	 */
	@Schema(description = "创建时间")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("创建时间")
	private String createTime;
	/**
	 * 是否bpo标识
	 */
	@Schema(description = "是否bpo标识")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("是否bpo标识")
	private String bpoFlag;

}
