package com.yifu.cloud.plus.v1.yifu.process.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.process.entity.TNodeRoute;
import com.yifu.cloud.plus.v1.yifu.process.service.TNodeRouteService;
import com.yifu.cloud.plus.v1.yifu.process.mapper.TNodeRouteMapper;
import org.springframework.stereotype.Service;

/**
 * 流程路由表（节点与节点之间的路由关系）
 *
 * @author hgw
 * @date 2020-07-16 15:44:02
 */
@Service
public class TNodeRouteServiceImpl extends ServiceImpl<TNodeRouteMapper, TNodeRoute> implements TNodeRouteService {

     /**
      * 流程路由表（节点与节点之间的路由关系）简单分页查询
      *
      * @param tNodeRoute 流程路由表（节点与节点之间的路由关系）
      * @return
      */
     @Override
     public IPage<TNodeRoute> getTNodeRoutePage(Page<TNodeRoute> page, TNodeRoute tNodeRoute) {
          return baseMapper.getTNodeRoutePage(page, tNodeRoute);
     }

     /**
      * @param processId 流程id
      * @Description: 删除
      * @Author: hgw
      * @Date: 2020/7/17 11:25
      * @return: int
      **/
     @Override
     public int deleteByProcessId(String processId) {
          return baseMapper.deleteByProcessId(processId);
     }

}
