package com.yifu.cloud.plus.v1.business.mapper.system;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.business.entity.system.TBusDept;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * B端部门表
 *
 * @author hgw
 * @date 2021-08-10 10:38:44
 */
@Mapper
public interface TBusDeptMapper extends BaseMapper<TBusDept> {
     /**
      * B端部门表简单分页查询
      *
      * @param tBusDept B端部门表
      * @return
      */
     IPage<TBusDept> getTBusDeptPage(Page<TBusDept> page, @Param("tBusDept") TBusDept tBusDept);

     List<TBusDept> getTBusDeptList(@Param("tBusDept") TBusDept tBusDept);

     List<TBusDept> getTBusDeptListAsso(@Param("tBusDept") TBusDept tBusDept);

     List<TBusDept> getTBusDeptSubList(@Param("id") int id, @Param("treeLogo") String treeLogo);

     List<TBusDept> getDeptByName(@Param("id") Integer id, @Param("name") String name);

     /**
      * @param oldLogo
      * @param newLogo
      * @Description: 批量更新子集的treeLogo
      * @Author: hgw
      * @Date: 2021/8/13 17:05
      * @return: int
      **/
     int updateAllTreeLogo(@Param("oldLogo") String oldLogo, @Param("newLogo") String newLogo);

}
