/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.permission.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.permission.entity.EkpQiwiWorkovertime;
import com.yifu.cloud.plus.v1.yifu.permission.entity.EkpQiwiZhaoPin;

import java.util.List;
import java.util.Map;

/**
 * E人事加班申请
 *
 * @author chenyuxi
 * @since 1.9.6
 */
public interface EkpQiweiWorkovertimeService extends IService<EkpQiwiWorkovertime> {

	/**
	 * 已被拉取的90天内的数据Map（定时任务是拉前一天的，手动执行是当面的。所以对90内的查重足够了。查全部数据对IO是浪费的）
	 * 用来： 拉取企E人事加班数据时，不覆盖数据
	 * @return java.util.Map<java.lang.String, java.lang.String>
	 **/
	Map<String, String> getWorkovertimeMapByTimeRange(String queryStartTime,String queryEndTime);

	/**
	 * 获取HCM审批通过的加班数据并存储到EKP
	 * @param startTime 开始时间
	 * @param endTime 结束时间
	 * @return R<List<EkpQiwiChuchai>>
	 **/
	List<EkpQiwiWorkovertime> saveWorkovertimeList(String startTime, String endTime);

}
