package com.yifu.cloud.plus.v1.yifu.process.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.process.entity.TNodeRouteCondition;
import com.yifu.cloud.plus.v1.yifu.process.service.TNodeRouteConditionService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.Valid;


/**
 * 流程路由条件
 *
 * @author hgw
 * @date 2020-07-16 15:44:02
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tnoderoutecondition")
@Tag(name = "流程路由条件")
public class TNodeRouteConditionController {

	@Resource
     private TNodeRouteConditionService tNodeRouteConditionService;

     /**
      * 简单分页查询
      *
      * @param page                分页对象
      * @param tNodeRouteCondition 流程路由条件
      * @return
      */
	 @Operation(summary = "简单分页查询")
     @GetMapping("/page")
     public R<IPage<TNodeRouteCondition>> getTNodeRouteConditionPage(Page<TNodeRouteCondition> page, TNodeRouteCondition tNodeRouteCondition) {
          return new R<>(tNodeRouteConditionService.getTNodeRouteConditionPage(page, tNodeRouteCondition));
     }


     /**
      * 通过id查询单条记录
      *
      * @param id
      * @return R
      */
	 @Operation(summary = "id查询")
     @GetMapping("/{id}")
     public R<TNodeRouteCondition> getById(@PathVariable("id") String id) {
          return new R<>(tNodeRouteConditionService.getById(id));
     }

     /**
      * 新增记录
      *
      * @param tNodeRouteCondition
      * @return R
      */
	 @Operation(summary = "新增")
     @PostMapping
     public R<Boolean> save(@Valid @RequestBody TNodeRouteCondition tNodeRouteCondition) {
          return new R<>(tNodeRouteConditionService.save(tNodeRouteCondition));
     }

     /**
      * 修改记录
      *
      * @param tNodeRouteCondition
      * @return R
      */
	 @Operation(summary = "修改")
     @SysLog("修改流程路由条件")
     @PutMapping
     public R<Boolean> update(@RequestBody TNodeRouteCondition tNodeRouteCondition) {
          return new R<>(tNodeRouteConditionService.updateById(tNodeRouteCondition));
     }

     /**
      * 通过id删除一条记录
      *
      * @param id
      * @return R
      */
	 @Operation(summary = "删除")
     @SysLog("删除流程路由条件")
     @DeleteMapping("/{id}")
     public R<Boolean> removeById(@PathVariable String id) {
          return new R<>(tNodeRouteConditionService.removeById(id));
     }

}
