/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.salary.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 所得税配置-薪资配置3
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@Data
public class TSalaryTaxConfigVo extends RowIndex implements Serializable {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "主键 不能为空")
	@Length(max = 32, message = "主键 不能超过32 个字符")
	@ExcelAttribute(name = "主键", isNotEmpty = true, errorInfo = "主键 不能为空", maxLength = 32)
	@Schema(description = "主键")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("主键")
	private String id;
	/**
	 * 累计预扣预缴应纳税所得额说明
	 */
	@Length(max = 32, message = "累计预扣预缴应纳税所得额说明 不能超过32 个字符")
	@ExcelAttribute(name = "累计预扣预缴应纳税所得额说明", maxLength = 32)
	@Schema(description = "累计预扣预缴应纳税所得额说明")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("累计预扣预缴应纳税所得额说明")
	private String taxableIncomeRemark;
	/**
	 * 预扣率（%）
	 */
	@NotBlank(message = "预扣率（%） 不能为空")
	@ExcelAttribute(name = "预扣率（%）", isNotEmpty = true, errorInfo = "预扣率（%） 不能为空")
	@Schema(description = "预扣率（%）")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("预扣率（%）")
	private Integer withholdingRate;
	/**
	 * 速算扣除数
	 */
	@NotBlank(message = "速算扣除数 不能为空")
	@ExcelAttribute(name = "速算扣除数", isNotEmpty = true, errorInfo = "速算扣除数 不能为空")
	@Schema(description = "速算扣除数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("速算扣除数")
	private BigDecimal quickDeducation;
	/**
	 * 最小区间值
	 */
	@NotBlank(message = "最小区间值 不能为空")
	@ExcelAttribute(name = "最小区间值", isNotEmpty = true, errorInfo = "最小区间值 不能为空")
	@Schema(description = "最小区间值")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("最小区间值")
	private BigDecimal minIncome;
	/**
	 * 最大区间值
	 */
	@NotBlank(message = "最大区间值 不能为空")
	@ExcelAttribute(name = "最大区间值", isNotEmpty = true, errorInfo = "最大区间值 不能为空")
	@Schema(description = "最大区间值")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("最大区间值")
	private BigDecimal maxIncome;
	/**
	 * 等级
	 */
	@NotBlank(message = "等级 不能为空")
	@ExcelAttribute(name = "等级", isNotEmpty = true, errorInfo = "等级 不能为空")
	@Schema(description = "等级")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("等级")
	private Integer level;
	/**
	 * 类型：0：工资；1：年终奖
	 */
	@NotBlank(message = "类型：0：工资；1：年终奖 不能为空")
	@ExcelAttribute(name = "类型：0：工资；1：年终奖", isNotEmpty = true, errorInfo = "类型：0：工资；1：年终奖 不能为空")
	@Schema(description = "类型：0：工资；1：年终奖")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("类型：0：工资；1：年终奖")
	private Integer type;
	/**
	 * 个税起征点或年终奖个税临界值
	 */
	@ExcelAttribute(name = "个税起征点或年终奖个税临界值")
	@Schema(description = "个税起征点或年终奖个税临界值")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个税起征点或年终奖个税临界值")
	private BigDecimal startPoint;

}
