/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.ekp.vo.EkpSalaryParamVo;
import com.yifu.cloud.plus.v1.yifu.salary.entity.THaveSalaryNosocial;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryAccount;
import com.yifu.cloud.plus.v1.yifu.salary.vo.*;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 工资报账主表（工资条）
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
@Mapper
public interface TSalaryAccountMapper extends BaseMapper<TSalaryAccount> {
	/**
	 * 工资报账主表（工资条）简单分页查询
	 *
	 * @param tSalaryAccount 工资报账主表（工资条）
	 * @return
	 */
	IPage<TSalaryAccount> getTSalaryAccountPage(Page<TSalaryAccount> page,
												@Param("tSalaryAccount") TSalaryAccount tSalaryAccount,
												@Param("deptNos") List<String> deptNos);

	List<TSalaryAccount> getTSalaryAccountPageDataByIds(@Param("tSalaryAccount") TSalaryAccount tSalaryAccount,
														@Param("ids") List<String> ids);

	List<String> getTSalaryAccountPageIds(@Param("page")Long page,
										  @Param("tSalaryAccount") TSalaryAccount tSalaryAccount,
										  @Param("deptNos") List<String> deptNos, @Param("size")Long size);

	int getTSalaryAccountPageCount(@Param("tSalaryAccount") TSalaryAccount tSalaryAccount,
												@Param("deptNos") List<String> deptNos);


	List<TSalaryAccount> getTSalaryAccountPageDiy( @Param("tSalaryAccount") TSalaryAccount tSalaryAccount,@Param("page")Long page, @Param("size")Long size);

	long getTSalaryAccountPageCountDiy( @Param("tSalaryAccount") TSalaryAccount tSalaryAccount);

	/**
	 * @param settleId
	 * @param settleMonth
	 * @Description: 版本2.6.6判重：对同一“结算主体”、同一“结算月份”、同一“报表类型”、同一“工资月份”、同一“身份证号”、同一“应发金额”进行校验
	 * <p>
	 * 校验导入数据重复的Map格式：# 身份证号_工资月份_报表类型_应发金额
	 * @Author: hgw
	 * @Date: 2021/9/17 18:06
	 * @return: java.util.List<java.lang.String>
	 **/
	List<AccountCheckVo> getAccountCheckList(@Param("settleId") String settleId, @Param("settleMonth") String settleMonth);

	List<AccountCheckVo> getAccountSpecialList(@Param("invoiceTitle") String invoiceTitle, @Param("unitId") String unitId, @Param("salaryMonth") String salaryMonth);

	List<AccountCheckVo> getAccountCheckListLabor(@Param("settleId") String settleId, @Param("settleMonth") String settleMonth);

	/**
	 * @param empIdCard
	 * @param nowYear
	 * @Description: 获取当前年最小计税月
	 * @Author: hgw
	 * @Date: 2022/1/19 17:56
	 * @return: java.lang.String
	 **/
	String getMinTaxMonthByNowYear(@Param("empIdCard") String empIdCard, @Param("nowYear") int nowYear);
	List<TSalaryAccount> getMinTaxMonthByNowYearAndList(@Param("empIdCardList") List<String> empIdCardList, @Param("nowYear") int nowYear);

	/**
	 * @return
	 * @Author fxj
	 * @Description 获取有工资无社保数据
	 * @Date 17:23 2022/8/16
	 * @Param
	 **/
	List<THaveSalaryNosocial> getLastMonthTHaveSalaryNosocial(@Param("month") String month,
															  @Param("month2") String month2,
															  @Param("month3") String month3);

	/**
	 * @Description: 薪资类型互斥校验 获取本年度身份证号列表
	 * @Author: huyc
	 * @Date: 2022/8/18
	 * @return:
	 **/
	List<String> getAccountYearCheckList();

	/**
	 * @param salaryId
	 * @Description: 获取薪资明细
	 * @Author: hgw
	 * @Date: 2022/8/29 16:52
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.ekp.vo.EkpSalaryParam>
	 **/
	List<EkpSalaryParamVo> getEkpSalaryParamList(@Param("salaryId") String salaryId);

	List<TSalaryAccount> noPageDiy(@Param("searchVo") TSalaryAccountSearchVo searchVo,
								   @Param("idList") List<String> idList);
	List<SalaryAccountExportVo> noPageDiyLast(@Param("searchVo") TSalaryAccountSearchVo searchVo,
											  @Param("idList") List<String> idList,
											  @Param("deptNos") List<String> deptNos);
	List<SalaryAccountExportVo> noPageDiyLastByIds(@Param("searchVo") TSalaryAccountSearchVo searchVo,
												   @Param("idList") List<String> idList);

	List<String> noPageDiyLastIds(@Param("searchVo") TSalaryAccountSearchVo searchVo,
											  @Param("idList") List<String> idList,
											  @Param("deptNos") List<String> deptNos);
	List<TSalaryAccountExportVo> auditExport(@Param("searchVo") TSalaryAccountSearchVo searchVo,
										   @Param("idList") List<String> idList);

	List<TSalaryAccountExportVo> auditExportDiy(@Param("searchVo") TSalaryAccountSearchVo searchVo,
											 @Param("idList") List<String> idList);

	List<TSalaryAccountExportVo> auditExportDiyByIds(@Param("idList") List<String> idList);


	List<String> auditExportDiyIds(@Param("searchVo") TSalaryAccountSearchVo searchVo,
												@Param("idList") List<String> idList);

	List<TSalaryAccountItemExportVo> auditExportSelectItems(@Param("idList") List<String> idList);


	List<TAuditExportStandardVo> auditExportStandard(@Param("idList") List<String> idList);

	List<TAuditExportItemVo> auditExportAnnualBonus(@Param("idList") List<String> idList);

	List<TAuditExportItemVo> auditExportExemptionPersionTax(@Param("idList") List<String> idList);

	List<TAuditExportItemVo> auditExportEnterpriseAnnuity(@Param("idList") List<String> idList);

	List<TAuditExportItemVo> auditExportPhoneSubsidy(@Param("idList") List<String> idList);

	List<TAuditExportItemVo> auditExportCarNoTax(@Param("idList") List<String> idList);

	List<TSalaryAccount> getAccountListBySalaryId(@Param("searchVo") TSalaryAccountSearchVo searchVo);

	// 导出报账专用hgw
	List<TSalaryAccountExportByEkpVo> getAccountListByApplyNo(@Param("applyNo") String applyNo);

	/**
	 * @Description: 根据工资id，返回报账明细（字段较少且有计算，其他地方勿用）
	 * @Author: hgw
	 * @Date: 2022/9/2 17:07
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryAccount>
	 **/
	List<TSalaryAccount> getListByIncome(@Param("salaryId") String salaryId);

	int noPageCountDiy(@Param("searchVo") TSalaryAccountSearchVo searchVo,
					   @Param("idList") List<String> idList);

	int noPageCountDiyLast(@Param("searchVo") TSalaryAccountSearchVo searchVo,
						   @Param("idList") List<String> idList,
						   @Param("deptNos")List<String> deptNos);

	int auditExportCount(@Param("searchVo") TSalaryAccountSearchVo searchVo,
					   @Param("idList") List<String> idList);

	int auditExportCountDiy(@Param("searchVo") TSalaryAccountSearchVo searchVo,
						 @Param("idList") List<String> idList);

	/**
	 * @param salaryId 工资表id
	 * @Description: 退表回退状态
	 * @Author: hgw
	 * @Date: 2022/11/8 15:41
	 * @return: void
	 **/
	void backSalaryBySalaryId(@Param("salaryId") String salaryId);

	/**
	 * @param page 分页
	 * @param settlementFormVo 结算单Vo
	 * @Description: B端薪酬第一个统计列表
	 * @Author: hgw
	 * @Date: 2020/8/21 11:38
	 * @return: com.baomidou.mybatisplus.core.metadata.IPage<com.yifu.cloud.v1.hrms.api.vo.SettlementFormVo>
	 **/
	IPage<SettlementFormVo> getSettlementFormVoPage(Page<SettlementFormVo> page
			, @Param("settlementFormVo") SettlementFormVo settlementFormVo
			, @Param("settleDepartIdList") List<String> settleDepartIdList);

	/**
	 * @param salaryFormId 结算单id
	 * @Description: 工资详情-上面的统计
	 * @Author: hgw
	 * @Date: 2020-8-21 17:55:24
	 * @return: com.baomidou.mybatisplus.core.metadata.IPage<com.yifu.cloud.v1.hrms.api.vo.SettlementFormVo>
	 **/
	SettlementFormVo getSettlementFormVoBySalaryFormId(@Param("salaryFormId") String salaryFormId);

	/**
	 * @param page
	 * @param salaryAccountAndItemVo
	 * @Description:  获取报账以及薪资
	 * @Author: hgw
	 * @Date: 2020/8/21 15:32
	 * @return: com.baomidou.mybatisplus.core.metadata.IPage<com.yifu.cloud.v1.hrms.api.vo.SalaryAccountAndItemVo>
	 **/
	IPage<SalaryAccountAndItemVo> getSalaryAccountAndItemVoPage(Page<SalaryAccountAndItemVo> page
			, @Param("salaryAccountAndItemVo") SalaryAccountAndItemVo salaryAccountAndItemVo);

	/**
	 * @param idList
	 * @Description: 根据idList获取报账信息
	 * @Author: hgw
	 * @Date: 2023/2/2 17:16
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryAccount>
	 **/
	List<TSalaryAccount> getListByIdList(@Param("idList") List<String> idList);

	List<String> getAccountIdForProve(@Param("startMouth") String startMouth, @Param("endMouth") String endMouth
			, @Param("emIdCard") String emIdCard, @Param("settleDepartId") String settleDepartId);

	List<String> getAccountMonthForProve(@Param("startMouth") String startMouth, @Param("endMouth") String endMouth
			, @Param("emIdCard") String emIdCard, @Param("settleDepartId") String settleDepartId);

	TSalaryAccountSumVo getAccountSumBySalaryId(@Param("salaryId") String salaryId);

	/**
	 * @param tSalaryAccount
	 * @Description: 报账按身份证导出，可以导出2个报账年份表
	 * @Author: hgw
	 * @Date: 2023/3/31 15:14
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryAccount>
	 **/
	List<TSalaryAccount> allYearExport(@Param("tSalaryAccount") TSalaryAccountSearchVo tSalaryAccount);

	List<TSalaryTypeThreeExportEkpVo> getAccountThreeListByApplyNo(String applyNo);

	List<TSalaryTypeFourExportEkpVo> getAccountFourListByApplyNo(String applyNo);

	/**
	 * @param empIdCard 身份证
	 * @Description: C端预入职查询薪资当前年度是否有发薪记录，无则返回0，有则返回数量
	 * @Author: hgw
	 * @Date: 2024/7/16 17:01
	 * @return: java.lang.String
	 **/
	int getAccountIdByIdCard(@Param("empIdCard") String empIdCard);

	/**
	 * @param salaryId 主表id
	 * @Description: 获取报账明细身份证
	 * @Author: hgw
	 * @Date: 2025/1/14 15:28
	 * @return: java.util.List<java.lang.String>
	 **/
	List<TSalaryAccount> getIdCardListBySalaryId(@Param("salaryId") String salaryId);

}
