/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 法大大企业接入方信息
 *
 * @author fxj
 * @date 2022-06-28 16:24:12
 */
@Data
@TableName("fdd_company_info")
@EqualsAndHashCode()
@Schema(description = "法大大企业接入方信息")
public class FddCompanyInfo {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description ="主键")
	private String id;

	/**
	 * 企业名称
	 */
	@Schema(description ="企业名称")
	private String companyName;

	/**
	 * 管理员unionId
	 */
	@Schema(description ="管理员unionId")
	private String managerUnionId;

	/**
	 * 管理员姓名
	 */
	@Schema(description ="管理员姓名")
	private String managerName;

	/**
	 * 企业unionId
	 */
	@Schema(description ="企业unionId")
	private String companyUnionId;


}
