/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;

/**
 * 法大大合同与员工合同信息
 *
 * @author fxj
 * @date 2022-06-29 16:21:51
 */
@Data
@TableName("fdd_contract_info")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "法大大合同与员工合同信息")
public class FddContractInfo extends BaseEntity {

    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @Schema(description ="主键")
    private String id;

    /**
     * 员工合同Id
     */
    @Schema(description ="员工合同Id")
    private String contractId;

    /**
     * 甲方用户ID: FDD_PERSON_ACCOUNT的个人实名ID
     */
    @Schema(description ="甲方用户ID: FDD_PERSON_ACCOUNT的个人实名ID")
    private String fddPersonAccountSendId;

    /**
     * 乙方用户ID: FDD_PERSON_ACCOUNT的个人实名ID
     */
    @Schema(description ="乙方用户ID: FDD_PERSON_ACCOUNT的个人实名ID")
    private String fddPersonAccountReceiveId;

    /**
     * 组织的unionId
     */
    @Schema(description ="组织的unionId")
    private String sendUnionid;

    /**
     * 签署人的unionId
     */
    @Schema(description ="签署人的unionId")
    private String receiveUnionid;

    /**
     * 定稿状态 1未定稿 2.定稿成功
     */
    @Schema(description ="定稿状态 1未定稿 2.定稿成功")
    private String taskStatus;

    /**
     * 签署发送方状态 1.未签署 2 已签署 3 已拒签 4 已撤销
     */
    @Schema(description ="签署发送方状态 1.未签署 2 已签署 3 已拒签 4 已撤销")
    private String sendSignStatus;

    /**
     * 定稿任务编号
     */
    @Schema(description ="定稿任务编号")
    private String taskId;

    /**
     * 定稿文件编号
     */
    @Schema(description ="定稿文件编号")
    private String fileId;

    /**
     * 草稿id,用于生成后续签署任务
     */
    @Schema(description ="草稿id,用于生成后续签署任务")
    private String draftId;

    /**
     * 是否删除 0未删除/1删除
     */
    @Schema(description ="是否删除 0未删除/1删除")
    private String deleteFlag;

    /**
     * 签署任务编号
     */
    @Schema(description ="签署任务编号")
    private String signTaskId;

    /**
     * 签署接收方状态 1.未签署 2 已签署 3 已拒签 4 已撤销
     */
    @Schema(description ="签署接收方状态 1.未签署 2 已签署 3 已拒签 4 已撤销")
    private String receiveSignStatus;

    /**
     * 签署状态 1.未签署 2 已签署  4 已撤销 5已拒签
     */
    @Schema(description ="签署状态 1.未签署 2 已签署  4 已撤销 5已拒签")
    private String signStatus;

    /**
     * 备注
     */
    @Schema(description ="备注")
    private String remark;

    /**
     * 合同模板id
     */
    @Schema(description ="合同模板id")
    private String fddTemplateId;

}
