/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;

/**
 * 法大大个人实名认证表
 *
 * @author huyc
 * @date 2022-06-28 16:24:12
 */
@Data
@TableName("fdd_person_account")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "法大大个人实名认证表")
public class FddPersonAccount extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description ="主键")
	private String id;

	/**
	 * 手机号
	 */
	@Schema(description ="手机号")
	private String moblie;

	/**
	 * 姓名
	 */
	@Schema(description ="姓名")
	private String name;

	/**
	 * 身份证号码
	 */
	@Schema(description ="身份证号码")
	private String idCard;

	/**
	 * 法大大用户唯一标识
	 */
	@Schema(description ="法大大用户唯一标识")
	private String unionid;

	/**
	 * 授权状态,0未授权 1已授权
	 */
	@Schema(description ="授权状态,0未授权 1已授权")
	private String authStatus;

	/**
	 * 0企业用户,1普通员工
	 */
	@Schema(description ="0企业用户,1普通员工")
	private String systemFlag;

	/**
	 * 法大大企业接入方信息id
	 */
	@Schema(description ="法大大企业接入方信息id")
	private String companyInfoId;

	/**
	 * 实名认证状态,0未实名 1已实名
	 */
	@Schema(description ="实名认证状态,0未实名 1已实名")
	private String realStatus;

	/**
	 * 实名短信发送：0未发送 1已发送
	 */
	@Schema(description ="实名短信发送：0未发送 1已发送")
	private String realMessageFlag;

	@Schema(description ="组织名称")
	@TableField(exist = false)
	private String companyName;

	@Schema(description ="法大大印章ID")
	@TableField(exist = false)
	private String sealId;

	@Schema(description ="印章名称")
	@TableField(exist = false)
	private String sealName;
}
