/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;

/**
 * 法大大日志记录表
 *
 * @author fxj
 * @date 2022-06-28 16:24:12
 */
@Data
@TableName("fdd_req_log")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "法大大日志记录表")
public class FddReqLog extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description ="主键")
	private String id;

	/**
	 * 请求数据
	 */
	@Schema(description ="请求数据")
	private String reqData;

	/**
	 * 返回数据
	 */
	@Schema(description ="返回数据")
	private String resData;

	/**
	 * 调用方法
	 */
	@Schema(description ="调用方法")
	private String methodName;

	/**
	 * 调用类名
	 */
	@Schema(description ="调用类名")
	private String className;

}
