/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;

/**
 * 法大大印章
 *
 * @author huyc
 * @date 2022-06-28 16:24:12
 */
@Data
@TableName("fdd_seal_info")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "法大大印章")
public class FddSealInfo extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description ="主键")
	private String id;

	/**
	 * 印章名称
	 */
	@Schema(description ="印章名称")
	private String sealName;

	/**
	 * 0：未删除； 1：已删除
	 */
	@Schema(description ="0：未删除； 1：已删除")
	private Integer deleteFlag;

	/**
	 * 法大大印章ID
	 */
	@Schema(description ="法大大印章ID")
	private String sealId;

	/**
	 * 印章状态 -1：审核不通过 1：待审核 2：审核通过
	 */
	@Schema(description ="印章状态 -1：审核不通过 1：待审核 2：审核通过")
	private String status;

	/**
	 * 系统章状态: 0:否 1:是
	 */
	@Schema(description ="系统章状态: 0:否 1:是")
	private String sysFlag;

	/**
	 * 印章对应的公司id
	 */
	@Schema(description ="印章对应的公司id")
	private String sealCompanyId;

}
