package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;

/**
 * 客户数据权限表
 *
 * @author pwang
 * @date 2019-07-19 16:22:22
 */
@Data
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("t_cutsomer_data_permisson")
@Schema(description = "客户数据权限表")
public class TCutsomerDataPermisson extends Model<TCutsomerDataPermisson> {
    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @Schema(description = "主键", name = "id")
    private String id;
    /**
     * 是否是数据所有者（0是1否）
     */
    @NotBlank(message = "是否是数据所有者(0是1否)不能为空")
    @Length(max = 1, message = "是否是数据所有者(0是1否)不能超过1个字符")
    @ExcelAttribute(name = "是否是数据所有者(0是1否)", isNotEmpty = true, errorInfo = "是否是数据所有者(0是1否)不能为空", maxLength = 1)
    @Schema(description = "是否是数据所有者(0是1否)", name = "isOwner")
    private String isOwner;
    /**
     * 客户id
     */
    @Length(max = 32, message = "客户id不能超过32个字符")
    @ExcelAttribute(name = "客户id", maxLength = 32)
    @Schema(description = "客户id", name = "customerId")
    private String customerId;
    /**
     * 合同主体id
     */
    @Length(max = 32, message = "合同主体id不能超过32个字符")
    @ExcelAttribute(name = "合同主体id", maxLength = 32)
    @Schema(description = "合同主体id", name = "contractId")
    private String contractId;
    /**
     * 结算主体id
     */
    @Length(max = 32, message = "结算主体id不能超过32个字符")
    @ExcelAttribute(name = "结算主体id", maxLength = 32)
    @Schema(description = "结算主体id", name = "settleDomainId")
    private String settleDomainId;
    /**
     * 授权来源
     */
    @NotBlank(message = "授权来源不能为空")
    @Length(max = 50, message = "授权来源不能超过50个字符")
    @ExcelAttribute(name = "授权来源", isNotEmpty = true, errorInfo = "授权来源不能为空", maxLength = 50)
    @Schema(description = "授权来源", name = "permissonSrc")
    private String permissonSrc;
    /**
     * 授权等级
     */
    @NotBlank(message = "授权等级不能为空")
    @ExcelAttribute(name = "授权等级", isNotEmpty = true, errorInfo = "授权等级不能为空")
    @Schema(description = "授权等级", name = "permissonLevel")
    private Integer permissonLevel;
    /**
     * 授权人
     */
    @NotBlank(message = "授权人不能为空")
    @Length(max = 32, message = "授权人不能超过32个字符")
    @Schema(description = "授权人", name = "permissionUser")
    private String permissionUser;
    /**
     * 被授权人
     */
    @NotBlank(message = "被授权人不能为空")
    @Length(max = 32, message = "被授权人不能超过32个字符")
    @ExcelAttribute(name = "被授权人", isNotEmpty = true, errorInfo = "被授权人不能为空", maxLength = 32)
    @Schema(description = "被授权人", name = "bePermissonUser")
    private String bePermissonUser;
    /**
     * 被授权时间
     */
    @NotBlank(message = "被授权时间不能为空")
    @ExcelAttribute(name = "被授权时间", isNotEmpty = true, errorInfo = "被授权时间不能为空")
    @Schema(description = "被授权时间", name = "bePermissionTime")
    private LocalDateTime bePermissionTime;
    /**
     * 备注
     */
    @Length(max = 50, message = "备注不能超过50个字符")
    @ExcelAttribute(name = "备注", maxLength = 50)
    @Schema(description = "备注", name = "remark")
    private String remark;

    @Length(max = 1, message = "是否是客服不能超过1个字符")
    @Schema(description = "是否是客服（0是1否）", name = "isCustomerService")
    private String isCustomerService;

    @Schema(description = "类型0:客户1:合同2:结算主体", name = "type")
    private String type;
    /**
     * 无参构造方法
     * @Author pwang
     * @Date 2019-11-15 12:12
     * @param
     * @return
     **/
    public TCutsomerDataPermisson(){
    }
}
