/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 档案划转日志表
 *
 * @author fxj
 * @date 2022-06-18 09:39:46
 */
@Data
@TableName("t_emp_change_info")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "档案划转日志表")
public class TEmpChangeInfo extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description ="主键")
	private String id;

    /**
     * 员工姓名
     */
    @Schema(description ="员工姓名")
    private String empName;

    /**
     * 原单位名称
     */
    @Schema(description ="原单位名称")
    private String oldDept;

    /**
     * 新单位名称
     */
    @Schema(description ="新单位名称")
    private String newDept;

    /**
     * 原结算主体
     */
    @Schema(description ="原项目名称")
    private String oldSettle;

    /**
     * 新结算主体
     */
    @Schema(description ="新项目名称")
    private String newSettle;

    /**
     * 项目档案id
     */
    @Schema(description ="项目档案id")
    private String proId;

    /**
     * 未结算费用 0：划转 1：不划转
     */
    @Schema(description ="未结算费用 0：划转 1：不划转")
    private String unsettleDeal;

    /**
     * 划转起始月
     */
    @Schema(description ="划转起始月")
    private String changeStartMonth;

	/**
	 * 结算主体id
	 */
	@Schema(description ="结算主体id")
	@TableField(exist = false)
	private String departId;

	/**
	 * 客户id
	 */
	@Schema(description ="客户id")
	@TableField(exist = false)
	private String customerId;

	/**
	 * 身份证号码
	 */
	@Schema(description ="身份证号码")
	private String empIdcard;

	/**
	 * 客户id
	 */
	@Schema(description ="客户id")
	@TableField(exist = false)
	private String unitId;

	/**
	 * 客户编码
	 */
	@Schema(description ="客户编码")
	@TableField(exist = false)
	private String unitNo;

	/**
	 * 项目id
	 */
	@Schema(description ="项目id")
	@TableField(exist = false)
	private String deptId;

	/**
	 * 项目编码
	 */
	@Schema(description ="项目编码")
	@TableField(exist = false)
	private String deptNo;
}
