/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;
import java.util.Date;

/**
 * 员工合同续签待办
 *
 * @author fxj
 * @date 2022-07-01 14:15:05
 */
@Data
@TableName("t_emp_contract_alert")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "员工合同续签待办")
public class TEmpContractAlert extends BaseEntity {

    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @ExcelAttribute(name = "主键" )
    @Schema(description ="主键")
    @ExcelIgnore
    private String id;

    /**
     * 员工名称
     */
    @ExcelAttribute(name = "员工名称" )
    @Schema(description ="员工名称")
    @ExcelProperty("员工名称")
    private String empName;

    /**
     * 员工ID
     */
    @ExcelAttribute(name = "员工ID" )
    @Schema(description ="员工ID")
    @ExcelProperty("员工ID")
    private String empId;

    /**
     * 项目名称
     */
    @ExcelAttribute(name = "项目名称" )
    @Schema(description ="项目名称")
    @ExcelProperty("项目名称")
    private String project;

    /**
     * 项目编码
     */
    @ExcelAttribute(name = "项目编码" )
    @Schema(description ="项目编码")
    @ExcelProperty("项目编码")
    private String projectNo;

    /**
     * 身份证号
     */
    @ExcelAttribute(name = "身份证号" )
    @Schema(description ="身份证号")
    @ExcelProperty("身份证号")
    private String empIdcard;

    /**
     * 员工编码
     */
    @ExcelAttribute(name = "员工编码" )
    @Schema(description ="员工编码")
    @ExcelProperty("员工编码")
    private String empCode;

    /**
     * 合同开始日期
     */
    @ExcelAttribute(name = "合同开始日期" )
    @Schema(description ="合同开始日期")
    @ExcelProperty("合同开始日期")
    private Date contractStart;

    /**
     * 合同截止日期
     */
    @ExcelAttribute(name = "合同截止日期" )
    @Schema(description ="合同截止日期")
    @ExcelProperty("合同截止日期")
    private Date contractEnd;

    /**
     * 档案地-省
     */
    @ExcelAttribute(name = "档案地-省" )
    @Schema(description ="档案地-省")
    @ExcelProperty("档案地-省")
    private String fileProvince;

    /**
     * 档案地-市
     */
    @ExcelAttribute(name = "档案地-市" )
    @Schema(description ="档案地-市")
    @ExcelProperty("档案地-市")
    private String fileCity;

    /**
     * 档案地-县
     */
    @ExcelAttribute(name = "档案地-县" )
    @Schema(description ="档案地-县")
    @ExcelProperty("档案地-县")
    private String fileTown;

    /**
     * 员工类型
     */
    @ExcelAttribute(name = "员工类型" )
    @Schema(description ="员工类型")
    @ExcelProperty("员工类型")
    private String empType;

    /**
     * 合同类型
     */
    @ExcelAttribute(name = "合同类型" )
    @Schema(description ="合同类型")
    @ExcelProperty("合同类型")
    private String contractType;

    /**
     * 合同期限
     */
    @ExcelAttribute(name = "合同期限" )
    @Schema(description ="合同期限")
    @ExcelProperty("合同期限")
    private String contractTerm;

    /**
     * 到期天数
     */
    @ExcelAttribute(name = "到期天数" )
    @Schema(description ="到期天数")
    @ExcelProperty("到期天数")
    private Integer daysDue;

    /**
     * 是否过期：0 未过期 1 过期
     */
    @ExcelAttribute(name = "是否过期：0 未过期 1 过期" )
    @Schema(description ="是否过期：0 未过期 1 过期")
    @ExcelProperty("是否过期：0 未过期 1 过期")
    private String dueFlag;

    /**
     * 过期天数
     */
    @ExcelAttribute(name = "过期天数" )
    @Schema(description ="过期天数")
    @ExcelProperty("过期天数")
    private Integer daysOver;

    /**
     * 首次提醒时间
     */
    @ExcelAttribute(name = "首次提醒时间" )
    @Schema(description ="首次提醒时间")
    @ExcelProperty("首次提醒时间")
    private Date firstAlertTime;

    /**
     * 提醒人
     */
    @ExcelAttribute(name = "提醒人" )
    @Schema(description ="提醒人")
    @ExcelProperty("提醒人")
    private String alertPerson;

	/**
	 * 处理状态 0 待处理  1  处理中
	 */
	@ExcelAttribute(name = "处理状态" )
	@Schema(description ="处理状态")
	@ExcelProperty("处理状态")
	private String handleStatus;

	/**
	 * 合同ID
	 */
	@ExcelAttribute(name = "合同ID" , isExport = false)
	@Schema(description ="合同ID")
	@ExcelIgnore
	private String contractId;

	/**
	 * 合同截止日期
	 */
	@TableField(exist = false)
	private Date auditTime;
}
