/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * 员工合同
 *
 * @author hgw
 * @date 2022-06-29 20:45:22
 */
@Data
@TableName("t_employee_contract_info")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "员工合同")
public class TEmployeeContractInfo extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键")
	private String id;

	/**
	 * 员工主键
	 */
	@Length(max = 32, message = "员工主键不能超过32个字符")
	@ExcelAttribute(name = "员工主键", maxLength = 32)
	@Schema(description = "员工主键", name = "empId")
	private String empId;
	/**
	 * 员工编码
	 */
	@NotBlank(message = "员工编码不能为空")
	@Length(max = 32, message = "员工编码不能超过32个字符")
	@ExcelAttribute(name = "员工编码", isNotEmpty = true, errorInfo = "员工编码不能为空", maxLength = 32)
	@Schema(description = "员工编码", name = "empNo")
	private String empNo;
	/**
	 * 员工姓名
	 */
	@Length(max = 32, message = "员工姓名不能超过32个字符")
	@ExcelAttribute(name = "员工姓名", maxLength = 32, needExport = true)
	@Schema(description = "员工姓名", name = "empName")
	private String empName;
	/**
	 * 员工身份证号
	 */
	@Length(max = 32, message = "员工身份证号不能超过32个字符")
	@ExcelAttribute(name = "员工身份证号", maxLength = 32, isIdCard = true, needExport = true)
	@Schema(description = "员工身份证号", name = "empIdcard")
	private String empIdcard;
	/**
	 * 合同类型
	 */
	@NotBlank(message = "合同类型不能为空")
	@Length(max = 32, message = "合同类型不能超过32个字符")
	@ExcelAttribute(name = "合同类型", maxLength = 32, needExport = true)
	@Schema(description = "合同类型", name = "contractName")
	private String contractName;
	/**
	 * 签订期限e
	 * 0	已完成一定工作任务为期限
	 * 1	固定期限
	 * 2	无固定期限
	 */
	@NotBlank(message = "签订期限不能为空")
	@Length(max = 32, message = "签订期限不能超过32个字符")
	@ExcelAttribute(name = "签订期限", maxLength = 32, isDataId = true, dataType = ExcelAttributeConstants.EMPLOYEE_CONTRACT_TYPE, needExport = true)
	@Schema(description = "签订期限", name = "contractType")
	private String contractType;
	/**
	 * 合同起始时间
	 */
	@NotBlank(message = "合同起始时间不能为空")
	@ExcelAttribute(name = "合同起始时间", needExport = true)
	@Schema(description = "合同起始时间", name = "contractStart")
	private Date contractStart;
	/**
	 * 合同到期时间
	 */
	@ExcelAttribute(name = "合同到期时间", needExport = true)
	@Schema(description = "合同到期时间", name = "contractEnd")
	private Date contractEnd;
	/**
	 * 项目名称
	 */
	@Length(max = 128, message = "项目名称不能超过128个字符")
	@ExcelAttribute(name = "项目名称", maxLength = 128)
	@Schema(description = "项目名称", name = "subjectDepart")
	private String subjectDepart;
	/**
	 * 客户名称
	 */
	@Length(max = 128, message = "客户名称不能超过128个字符")
	@ExcelAttribute(name = "客户名称", maxLength = 128)
	@Schema(description = "客户名称", name = "subjectUnit")
	private String subjectUnit;
	/**
	 * 签订类型（字典也是汉字
	 */
	@NotBlank(message = "签订类型不能为空")
	@Length(max = 100, message = "签订类型不能超过1个字符")
	@ExcelAttribute(name = "签订类型", isNotEmpty = true, errorInfo = "签订类型不能为空", maxLength = 100)
	@Schema(description = "签订类型（字典也是汉字）", name = "situation")
	private String situation;
	/**
	 * 合同年限
	 */
	@NotBlank(message = "合同年限不能为空")
	@ExcelAttribute(name = "合同年限", errorInfo = "合同年限不能为空")
	@Schema(description = "合同年限", name = "contractTerm")
	private String contractTerm;
	/**
	 * 合同编码
	 */
	@NotBlank(message = "合同编码不能为空")
	@Length(max = 50, message = "合同编码不能超过50个字符")
	@ExcelAttribute(name = "合同编码", maxLength = 50)
	@Schema(description = "合同编码", name = "contractNo")
	private String contractNo;
	/**
	 * 备注
	 */
	@Length(max = 200, message = "不能超过200个字符")
	@ExcelAttribute(name = "备注", maxLength = 200)
	@Schema(description = "备注", name = "remark")
	private String remark;

	/**
	 * 是否作废 0否/1是
	 */
	@Length(max = 32, message = "是否作废 0否/1是不能超过32个字符")
	@ExcelAttribute(name = "是否作废 0否/1是")
	@Schema(description = "是否作废 0否/1是", name = "isObsolete")
	private String isObsolete;

	/**
	 * 作废理由
	 */
	@Length(max = 32, message = "作废理由不能超过32个字符")
	@ExcelAttribute(name = "作废理由")
	@Schema(description = "作废理由", name = "obsoleteReason")
	private String obsoleteReason;
	/**
	 * 是否归档 0是/1否
	 */
	@Length(max = 1, message = "是否归档 0是/1否不能超过1个字符")
	@ExcelAttribute(name = "是否归档 0是/1否", maxLength = 1)
	@Schema(description = "是否归档 0是/1否", name = "isFile")
	private String isFile;

	/**
	 * 是否在用 0是/1否
	 */
	@Length(max = 1, message = "是否在用 0是/1否不能超过1个字符")
	@ExcelAttribute(name = "是否在用 0是/1否", maxLength = 1)
	@Schema(description = "是否在用 0是/1否", name = "inUse")
	private String inUse;
	/**
	 * 数据迁移ID
	 */
	@ExcelAttribute(name = "数据迁移ID")
	@Schema(description = "数据迁移ID", name = "oldId")
	private Integer oldId;

	/**
	 * 入职日期
	 */
	@ExcelAttribute(name = "入职日期")
	@Schema(description = "入职日期", name = "enjoinDate")
	private LocalDateTime enjoinDate;

	/**
	 * 合同岗位
	 */
	@Length(max = 32, message = "合同岗位不能超过32个字符")
	@ExcelAttribute(name = "合同岗位", maxLength = 32, needExport = true)
	@Schema(description = "合同岗位", name = "post")
	private String post;
	/**
	 * 工时制（数据字典） 1标准工时 2 综合工时 3不定时工时制
	 */
	@Length(max = 32, message = "工时制不能超过32个字符")
	@ExcelAttribute(name = "工时制", maxLength = 32, isDataId = true, dataType = ExcelAttributeConstants.WORKING_HOURS)
	@Schema(description = "工时制（数据字典） 1标准工时 2 综合工时 3不定时工时制", name = "workingHours")
	private String workingHours;
	/**
	 * 档案柜号
	 */
	@Length(max = 50, message = "档案柜号不能超过50个字符")
	@ExcelAttribute(name = "档案柜号", maxLength = 50)
	@Schema(description = "档案柜号", name = "fileCabinetNo")
	private String fileCabinetNo;

	/**
	 * 结算主体
	 */
	@NotBlank(message = "结算主体不能为空")
	@Length(max = 32, message = "结算主体不能超过32个字符")
	@ExcelAttribute(name = "结算主体", errorInfo = "结算主体不能为空", isOrgan = true, maxLength = 32)
	@Schema(description = "结算主体", name = "settleDomain")
	private String settleDomain;

	/**
	 * 员工类型
	 */
	@ExcelAttribute(name = "员工类型", errorInfo = "员工类型不能为空", maxLength = 32, isDataId = true, dataType = ExcelAttributeConstants.PERSONNEL_TYPE)
	@TableField(exist = false)
	private String empType;

	/**
	 * @Author: wangan
	 * @Date: 2019/11/25
	 * @Description: 用于首页代办任务跳转，参数指定
	 * @return:
	 **/
	@TableField(exist = false)
	@Schema(description = "首页代办任务跳转(0:代办任务标识，其他：非代办任务标识", name = "workBranchjumpFlag")
	private String workBranchjumpFlag;
	/******************************查询优化新增字段开始***********************************/
	/**
	 * 档案-省
	 */
	@ExcelAttribute(name = "档案-省", maxLength = 32, isDataId = true, isArea = true, parentField = "")
	@Schema(description = "档案-省", name = "fileProvince")
	private Integer fileProvince;
	/**
	 * 档案-市
	 */
	@ExcelAttribute(name = "档案-市", maxLength = 32, isDataId = true, isArea = true, parentField = "fileProvince")
	@Schema(description = "档案-市", name = "fileCity")
	private Integer fileCity;
	/**
	 * 档案-县
	 */
	@ExcelAttribute(name = "档案-县", maxLength = 32, isDataId = true, isArea = true, parentField = "fileCity")
	@Schema(description = "档案-县", name = "fileTown")
	private Integer fileTown;

	/**
	 * 在职状态 0是/1否
	 */
	@ExcelAttribute(name = "在职状态", errorInfo = "在职状态 0是/1否不能为空", maxLength = 1, isDataId = true, readConverterExp = "0=在职,1=离职")
	@Schema(description = "在职状态 0是/1否", name = "workFlag")
	private String workFlag;
	/**
	 * 在职状态扩展 0 在职 1 个人离职 2 单位辞退 3 临时 4 特殊人员 5 退休 6 退休返聘
	 */
	@ExcelAttribute(name = "在职细分", isDataId = true, dataType = "work_falg_sub")
	@Schema(description = "在职细分 0 在职 1 个人离职 2 单位辞退 3 临时 4 特殊人员 5 退休 6 退休返聘", name = "workingStatusSub")
	private String workingStatusSub;

	/**
	 * 合同试用期开始时间
	 */
	@ExcelAttribute(name = "试用期开始时间")
	@Schema(description = "合同试用期开始时间", name = "periodStart")
	private Date periodStart;
	/**
	 * 合同试用期结束时间
	 */
	@ExcelAttribute(name = "试用期结束时间")
	@Schema(description = "合同试用期结束时间", name = "periodEnd")
	private Date periodEnd;
	/**
	 * 试用期工资元/月
	 */
	@ExcelAttribute(name = "试用期工资元/月")
	@Schema(description = "试用期工资(元/月)", name = "periodSalaryPerMonth")
	private BigDecimal periodSalaryPerMonth;
	/**
	 * 工资形式 1.计时工资 2.计件工资 3.其他
	 */
	@Length(max = 1, message = "工资形式不能超过1个字符")
	@ExcelAttribute(name = "工资形式", maxLength = 1, isDataId = true, dataType = ExcelAttributeConstants.SALARY_TYPE)
	@Schema(description = "工资形式 1.计时工资 2.计件工资 3.其他", name = "salaryType")
	private String salaryType;
	/**
	 * 计时工资 工资标准 元/月
	 */
	@ExcelAttribute(name = "计时工资(元/月)")
	@Schema(description = "计时工资 工资标准 元/月 ", name = "salaryStandardPerHour")
	private BigDecimal salaryStandardPerHour;
	/**
	 * 计件工资 工资标准单价/元
	 */
	@ExcelAttribute(name = "计件工资(单价/元)")
	@Schema(description = "计件工资 工资标准单价/元 ", name = "salaryStandardPerPiece")
	private BigDecimal salaryStandardPerPiece;
	/******************************查询优化新增字段结束***********************************/
	/**
	 * 派单标识  默认null 如果派单产生 为1  派单审核通过 清空标识  2020-09-27 fxj
	 */
	@ExcelAttribute(name = "派单标识")
	@Schema(description = "派单标识", name = "dispatchFlag")
	private String dispatchFlag;
	/**
	 * 邮件提醒用户id
	 */
	@Length(max = 32, message = "邮件提醒用户id不能超过32个字符")
	@Schema(description = "邮件提醒用户id默认是创建人", name = "warnEmailUserId")
	private String warnEmailUserId;
	/**
	 * 合同终止时间串 解决freemarker 生产环境时间格式与测试环境不一样问提
	 */
	@TableField(exist = false)
	private String endDateStr;

	@ExcelAttribute(name = "电子合同", readConverterExp = "0=不开通,1=开通")
	@Schema(description = "电子合同:0不开通 1开通", name = "fddFlag")
	private String fddFlag;

	@ExcelAttribute(name = "是否需要电子签", readConverterExp = "0=正常合同,1=需要电子签")
	@Schema(description = "是否需要电子签:0正常合同 1需要电子签", name = "isSign")
	private Integer isSign;

	/**
	 * 客户id
	 */
	@Schema(description = "客户id")
	private String customerId;

	/**
	 * 客户编码
	 */
	@Schema(description = "客户编码")
	private String unitNo;

	/**
	 * 项目编码
	 */
	@Schema(description = "项目编码")
	private String deptNo;

	/**
	 * 申请编码
	 */
	@Schema(description = "申请编码")
	private String applyNo;

	/**
	 * 审核状态（0：待提交；1：待审核；2审核通过；3审核不通过）
	 */
	@Schema(description = "审核状态（0：待提交；1：待审核；2审核通过；3审核不通过）")
	private Integer auditStatus;

	/**
	 * 最新审核通过时间
	 */
	@DateTimeFormat("yyyy-MM-dd HH:mm:ss")
	@Schema(description = "最新审核通过时间")
	private LocalDateTime auditTimeLast;

	/**
	 * 删除状态（0未删除；1已删除）
	 */
	@Schema(description = "删除状态（0未删除；1已删除）")
	private Integer deleteFlag;

	/**
	 * 审核原因
	 */
	@Schema(description = "审核说明，前端传参用，字段不存数据库，数据库存审核记录")
	@TableField(exist = false)
	private String auditRemark;

	/**
	 * 员工类型（字典值，0外包1派遣2代理）
	 */
	@ExcelAttribute(name = "员工类型", isDataId = true, dataType = ExcelAttributeConstants.EMP_NATRUE)
	@Schema(description = "员工类型（字典值，0外包1派遣2代理）")
	@Size(max = 1, message = "员工类型不可超过1位")
	private String empNatrue;

	/**
	 * 合同甲方
	 */
	@NotBlank(message = "合同甲方不能为空")
	@Length(max = 50, message = "合同甲方不能超过50个字符")
	@ExcelAttribute(name = "合同甲方", maxLength = 50, needExport = true)
	@Schema(description = "合同甲方")
	@Size(max = 50, message = "合同甲方不可超过50位")
	private String contractParty;

	/**
	 * 业务细分
	 */
	@NotBlank(message = "业务细分不能为空")
	@Length(max = 32, message = "业务细分不能超过32个字符")
	@ExcelAttribute(name = "业务细分", maxLength = 32, needExport = true)
	@Schema(description = "业务细分（存lable）", name = "contractName")
	private String contractSubName;

	/**
	 * 原因说明
	 */
	@Length(max = 200, message = "原因说明不能超过200个字符")
	@ExcelAttribute(name = "原因说明", maxLength = 200, needExport = true)
	@Schema(description = "原因说明", name = "reason")
	private String reason;

	/**
	 * 作废、终止选择的合同id
	 */
	@Length(max = 32, message = "作废、终止选择的合同id不能超过32个字符")
	@ExcelAttribute(name = "作废、终止选择的合同id", maxLength = 32)
	@Schema(description = "作废、终止选择的合同id", name = "reason")
	private String oldContractId;

	/**
	 * 是否附件 0是/1否
	 */
	@Schema(description = "是否附件 0是/1否")
	@TableField(exist = false)
	private String isAtta;

	@Schema(description = "附件idList")
	@TableField(exist = false)
	private List<String> attaList;

	@TableField(exist = false)
	@Schema(description = "选中的idList")
	private List<String> idList;

	@TableField(exist = false)
	@Schema(description = "导出的表头的Set")
	private Set<String> exportFields;

	@TableField(exist = false)
	@Schema(description = "创建时间起")
	private String createTimeStart;

	@TableField(exist = false)
	@Schema(description = "创建时间止")
	private String createTimeEnd;

	@TableField(exist = false)
	@Schema(description = "归档列表查询标志，1：是归档，去除作废、终止两种")
	private Integer isFilePage;

}
