/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 结算主体表
 *
 * @author hgw
 * @date 2022-06-20 10:02:28
 */
@Data
@TableName("t_settle_domain")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "结算主体表")
public class TSettleDomain extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键")
	private String id;

	/**
	 * 结算主体编码
	 */
	@Schema(description = "结算主体编码")
	private String departNo;

	/**
	 * 结算主体名称
	 */
	@Schema(description = "结算主体名称")
	private String departName;

	/**
	 * 是否是新业务（0是/1否）
	 */
	@Schema(description = "是否是新业务（0是/1否）")
	private String isNew;

	/**
	 * 新业务备注
	 */
	@Schema(description = "新业务备注")
	private String newRemark;

	/**
	 * 是否删除（0否/1是）
	 */
	@Schema(description = "是否删除（0否/1是）")
	private String deleteFlag;

	/**
	 * 服务审核标识（0是通过，1是不通过，2待审核，3待提交，4经理通过，5经理不通过）默认2
	 */
	@Schema(description = "服务审核标识（0是通过，1是不通过，2待审核，3待提交，4经理通过，5经理不通过）默认2")
	private String dpAuditFlag;

	/**
	 * 原ID
	 */
	@Schema(description = "原ID")
	private Integer oldId;

	/**
	 * 合同主体
	 */
	@Schema(description = "合同主体")
	private String belongContract;

	/**
	 * 业务经理审核意见
	 */
	@Schema(description = "业务经理审核意见")
	private String dpAuditOpinion;

	/**
	 * 审核人id
	 */
	@Schema(description = "审核人id")
	private String dpAuditMan;

	/**
	 * 审核人名称
	 */
	@Schema(description = "审核人名称")
	private String dpAuditManName;

	/**
	 * 最后审核时间
	 */
	@Schema(description = "最后审核时间")
	private LocalDateTime lastAuditDate;

	/**
	 * 服务项目
	 */
	@Schema(description = "服务项目")
	private String serverItem;

	/**
	 * 收入归属
	 */
	@Schema(description = "收入归属")
	private String incomeBelong;

	/**
	 * 收入归属细分
	 */
	@Schema(description = "收入归属细分")
	private String incomeBelongSub;

	/**
	 * 所属客户
	 */
	@Schema(description = "所属客户")
	private String customerId;

	/**
	 * 创建者姓名
	 */
	@Schema(description = "创建者姓名")
	private String createUserName;

	/**
	 * 最后提交人
	 */
	@Schema(description = "最后提交人")
	private String commitUser;

	/**
	 * 最后提交人姓名
	 */
	@Schema(description = "最后提交人姓名")
	private String commitUserName;

	/**
	 * 账户余额
	 */
	@Schema(description = "账户余额")
	private BigDecimal balance;

	/**
	 * 开票余额
	 */
	@Schema(description = "开票余额")
	private BigDecimal invoiceBalance;

	/**
	 * 首次审核通过标志0审核通过1未审核通过
	 */
	@Schema(description = "首次审核通过标志0审核通过1未审核通过")
	private String firstPassFlag;

	/**
	 * 首次审核通过时间
	 */
	@Schema(description = "首次审核通过时间")
	private LocalDateTime firstPassTime;

	/**
	 * 省
	 */
	@Schema(description = "省")
	private Integer province;

	/**
	 * 市
	 */
	@Schema(description = "市")
	private Integer city;

	/**
	 * 县
	 */
	@Schema(description = "县")
	private Integer town;

	/**
	 * 服务状态：0正常 1停止服务
	 */
	@Schema(description = "服务状态：0正常 1停止服务")
	private String stopFlag;

	/**
	 * 在职人数（正式加临时）
	 */
	@Schema(description = "在职人数（正式加临时）")
	private Integer employeeNum;

	/**
	 * 停止时间
	 */
	@Schema(description = "停止时间")
	private LocalDateTime stopDate;

	/**
	 * stopReason
	 */
	@Schema(description = "stopReason")
	private String stopReason;

	/**
	 * stopUser
	 */
	@Schema(description = "stopUser")
	private String stopUser;

	/**
	 * stopUserName
	 */
	@Schema(description = "stopUserName")
	private String stopUserName;

	/**
	 * 0：人事；1：非人事
	 */
	@Schema(description = "0：人事；1：非人事")
	private Integer type;

	/**
	 * 业务类型分类
	 */
	@Schema(description = "业务类型分类")
	private String businessPrimaryType;

	/**
	 * 业务类型二级分类
	 */
	@Schema(description = "业务类型二级分类")
	private String businessSecondType;

	/**
	 * 业务类型三级分类
	 */
	@Schema(description = "业务类型三级分类")
	private String businessThirdType;

	/**
	 * 业务经理审核意见
	 */
	@Schema(description = "业务经理审核意见")
	private String managerAuditOpinion;

	/**
	 * 审核人id
	 */
	@Schema(description = "审核人id")
	private String managerAuditMan;

	/**
	 * 审核人名称
	 */
	@Schema(description = "审核人名称")
	private String managerAuditManName;

	/**
	 * 审核人审核的时间
	 */
	@Schema(description = "审核人审核的时间")
	private LocalDateTime auditTime;

	/**
	 * 经理审核时间
	 */
	@Schema(description = "经理审核时间")
	private LocalDateTime managerAuditTime;

	/**
	 * 创建类型：0 合同之后 1 合同之前
	 */
	@Schema(description = "创建类型：0 合同之后 1 合同之前")
	private String createType;

	/**
	 * 关联合同：0是1否
	 */
	@Schema(description = "关联合同：0是1否")
	private String relateFlag;

	/**
	 * 异常说明
	 */
	@Schema(description = "异常说明")
	private String exceptionRemark;

	/**
	 * 是否存在垫付 0 不存在，1存在
	 */
	@Schema(description = "是否存在垫付 0 不存在，1存在")
	private String existAdvancePayment;

	/**
	 * 回款周期1-12
	 */
	@Schema(description = "回款周期1-12")
	private String backPayCycle;


}
