package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author fxj
 * @Date 2022/6/29
 * @Description
 * @Version 1.0
 */
@Data
public class EmpBadRecordVo extends RowIndex implements Serializable {
	/**
	 * 员工姓名
	 */
	@ExcelAttribute(name = "员工姓名" ,maxLength = 20)
	@Schema(description ="员工姓名")
	@ExcelProperty("员工姓名")
	private String empName;

	/**
	 * 身份证号
	 */
	@ExcelAttribute(name = "身份证号" ,maxLength = 20, isNotEmpty = true)
	@Schema(description ="身份证号")
	@ExcelProperty("身份证号")
	private String empIdcard;

	/**
	 * 产生项目
	 */
	@Schema(description ="产生项目")
	@ExcelIgnore
	private String project;

	/**
	 * 项目编码
	 */
	@ExcelAttribute(name = "产生项目编码" ,maxLength = 50, isNotEmpty = true)
	@Schema(description ="产生项目编码")
	@ExcelProperty("产生项目编码")
	private String projectCode;

	/**
	 * 发生时间
	 */
	@ExcelAttribute(name = "发生时间" , isNotEmpty = true)
	@Schema(description ="发生时间")
	@ExcelProperty("发生时间")
	private Date happenTime;

	/**
	 * 备注
	 */
	@ExcelAttribute(name = "不良记录描述", maxLength = 200, isNotEmpty = true)
	@Schema(description ="不良记录描述")
	@ExcelProperty("不良记录描述")
	private String remark;

	/**
	 * 费用损失 （费用损失与其他费用损失其一必填）
	 */
	@ExcelAttribute(name = "费用损失" , isFloat = true,max = "999999999.99")
	@Schema(description ="费用损失 （费用损失与其他费用损失其一必填）")
	@ExcelProperty("费用损失")
	private BigDecimal loseFee;

	/**
	 * 其他损失 （费用损失与其他费用损失其一必填）
	 */
	@ExcelAttribute(name = "其他损失" , isFloat = true,max = "999999999.99")
	@Schema(description ="其他损失 （费用损失与其他费用损失其一必填）")
	@ExcelProperty("其他损失")
	private BigDecimal loseFeeOther;
}
