package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author fxj
 * @Date 2022/6/22
 * @value
 * @Version 1.0
 */
@Data
@ColumnWidth(30)
public class EmpCertificateExcelVO extends RowIndex implements Serializable {

	private static final long serialVersionUID = 1L;
	/**
	 * 员工姓名
	 */
	@ExcelAttribute(name = "员工姓名",isNotEmpty = true,errorInfo = "员工姓名不可为空",maxLength = 20)
	@NotNull(message = "员工姓名不可为空")
	@ExcelProperty(value ="员工姓名")
	private String empName;
	/**
	 * 员工身份证
	 */
	@ExcelAttribute(name = "身份证号",isNotEmpty = true,errorInfo = "员工身份证不可为空",maxLength = 20)
	@NotNull(message = "员工身份证不可为空")
	@ExcelProperty(value ="身份证号")
	private String empIdcard;

	/**
	 * 资格类型
	 */
	@ExcelAttribute(name = "资格类型",isNotEmpty = true,errorInfo = "资格类型不可为空",isDataId = true, dataType = ExcelAttributeConstants.QUALIFICATION_TYPE)
	@NotNull(message = "资格类型不可为空")
	@ExcelProperty(value ="资格类型")
	private String qualificationType;

	/**
	 * 资格等级
	 */
	@ExcelAttribute(name = "资格等级",isNotEmpty = true,errorInfo = "资格等级不可为空",isDataId = true, dataType = ExcelAttributeConstants.QUALIFICATION_LEVEL)
	@NotNull(message = "资格等级不可为空")
	@ExcelProperty(value ="资格等级")
	private String qualificationLevel;

	/**
	 * 证书编号
	 */
	@ExcelAttribute(name = "证书编号",maxLength = 50)
	@ExcelProperty(value ="证书编号")
	private String certificationNo;

	/**
	 * 获取方式
	 */
	@ExcelAttribute(name = "获取方式",isDataId = true, dataType = ExcelAttributeConstants.OBTAIN_TYPE)
	@ExcelProperty(value ="获取方式")
	private String obtainType;

	/**
	 * 评定机构
	 */
	@ExcelAttribute(name = "评定机构",maxLength = 50)
	@ExcelProperty(value ="评定机构")
	private String assessmentUnit;

	/**
	 * 申报年度
	 */
	@ExcelAttribute(name = "申报年度",isInteger = true)
	@ExcelProperty(value ="申报年度")
	private String declareYear;

	/**
	 * 是否最高资格0是/1否
	 */
	@ExcelAttribute(name = "是否最高资格",isNotEmpty = true,errorInfo = "是否最高资格不可为空",readConverterExp = "0=是,1=否")
	@NotNull(message = "是否最高资格不可为空")
	@ExcelProperty(value ="是否最高资格")
	private String heightIdentification;
	/**
	 * 备注
	 */
	@ExcelAttribute(name = "备注",maxLength = 200)
	@ExcelProperty(value ="备注")
	private String remark;
}
