package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.Date;

/**
 * @Author fxj
 * @Date 2022/7/19
 * @Description  派单新增合同
 * @Version 1.0
 */
@Data
public class EmpContractDispatchVo implements Serializable {
	/**
	 * 合同主键ID
	 */
	@Schema(description = "合同主键ID", name = "empId")
	private String id;

	/**
	 * 员工主键
	 */
	@Length(max = 32, message = "员工主键不能超过32个字符")
	@ExcelAttribute(name = "员工主键", maxLength = 32)
	@Schema(description = "员工主键", name = "empId")
	private String empId;
	/**
	 * 员工编码
	 */
	@NotBlank(message = "员工编码不能为空")
	@Length(max = 32, message = "员工编码不能超过32个字符")
	@ExcelAttribute(name = "员工编码", isNotEmpty = true, errorInfo = "员工编码不能为空", maxLength = 32)
	@Schema(description = "员工编码", name = "empNo")
	private String empNo;
	/**
	 * 员工姓名
	 */
	@Length(max = 20, message = "员工姓名不能超过20个字符")
	@ExcelAttribute(name = "员工姓名", isNotEmpty = true, maxLength = 20, needExport = true)
	@Schema(description = "员工姓名", name = "empName")
	private String empName;
	/**
	 * 员工身份证号
	 */
	@Length(max = 20, message = "身份证号不能超过20个字符")
	@ExcelAttribute(name = "身份证号", isNotEmpty = true, maxLength = 20, isIdCard = true, needExport = true)
	@Schema(description = "身份证号", name = "empIdcard")
	private String empIdcard;
	/**
	 * 员工类型
	 */
	@ExcelAttribute(name = "员工类型", errorInfo = "员工类型不能为空", maxLength = 32, isDataId = true, dataType = ExcelAttributeConstants.PERSONNEL_TYPE)
	@TableField(exist = false)
	private String empType;
	/**
	 * 项目编码
	 */
	@Length(max = 20, message = "项目编码不能超过20个字符")
	@ExcelAttribute(name = "项目编码", isNotEmpty = true, maxLength = 20, needExport = true)
	@Schema(description = "项目编码")
	private String deptNo;

	/**
	 * 签订类型（字典）
	 */
	@NotBlank(message = "签订类型不能为空")
	@Length(max = 20, message = "签订类型不能超过20个字符")
	@ExcelAttribute(name = "签订类型", isNotEmpty = true, errorInfo = "签订类型不能为空", maxLength = 20, isDataId = true, dataType = ExcelAttributeConstants.EMPLOYEE_SITUATION_TYPE)
	@Schema(description = "签订类型（字典）", name = "situation")
	private String situation;

	/**
	 * 合同类型
	 */
	@NotBlank(message = "合同类型不能为空")
	@Length(max = 32, message = "合同类型不能超过32个字符")
	@ExcelAttribute(name = "合同类型", maxLength = 32, needExport = true)
	@Schema(description = "合同类型", name = "contractName")
	private String contractName;

	/**
	 * 业务细分
	 */
	@NotBlank(message = "业务细分不能为空")
	@Length(max = 32, message = "业务细分不能超过32个字符")
	@ExcelAttribute(name = "业务细分", maxLength = 32, needExport = true)
	@Schema(description = "业务细分", name = "contractName")
	private String contractSubName;

	/**
	 * 合同甲方
	 */
	@Length(max = 50, message = "原因说明不能超过200个字符")
	@ExcelAttribute(name = "合同甲方", maxLength = 50, needExport = true)
	@Schema(description = "合同甲方")
	@Size(max = 50, message = "合同甲方不可超过50位")
	private String contractParty;

	/**
	 * 签订期限
	 * 0	已完成一定工作任务为期限
	 * 1	固定期限
	 * 2	无固定期限
	 */
	@NotBlank(message = "签订期限不能为空")
	@Length(max = 32, message = "签订期限不能超过32个字符")
	@ExcelAttribute(name = "签订期限", maxLength = 32, isDataId = true, dataType = ExcelAttributeConstants.EMPLOYEE_CONTRACT_TYPE, needExport = true)
	@Schema(description = "签订期限", name = "contractType")
	private String contractType;

	/**
	 * 合同起始时间
	 */
	@NotBlank(message = "起始日期不能为空")
	@DateTimeFormat("yyyy-MM-dd")
	@JsonFormat(pattern = "yyyy-MM-dd")
	@ExcelAttribute(name = "起始日期", isDate = true)
	@Schema(description = "起始日期", name = "contractStart")
	private Date contractStart;
	/**
	 * 合同到期时间
	 */
	@ExcelAttribute(name = "截止日期", needExport = true, isDate = true)
	@DateTimeFormat("yyyy-MM-dd")
	@JsonFormat(pattern = "yyyy-MM-dd")
	@Schema(description = "截止日期", name = "contractEnd")
	private Date contractEnd;

	/**
	 * 合同岗位
	 */
	@Length(max = 32, message = "合同岗位不能超过32个字符")
	@ExcelAttribute(name = "合同岗位", maxLength = 32, needExport = true)
	@Schema(description = "合同岗位", name = "post")
	private String post;

	/**
	 * 工时制（数据字典） 1标准工时 2 综合工时 3不定时工时制
	 */
	@Length(max = 32, message = "工时制不能超过32个字符")
	@ExcelAttribute(name = "工时制", maxLength = 32, isDataId = true, dataType = ExcelAttributeConstants.WORKING_HOURS)
	@Schema(description = "工时制（数据字典） 1标准工时 2 综合工时 3不定时工时制", name = "workingHours")
	private String workingHours;

	/**
	 * 备注
	 */
	@Length(max = 200, message = "不能超过200个字符")
	@ExcelAttribute(name = "备注", maxLength = 200)
	@Schema(description = "备注", name = "remark")
	private String remark;
}
