/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;
import java.util.Set;

/**
 * 员工合同
 *
 * @author hgw
 * @date 2022-06-29 20:45:22
 */
@Data
@ColumnWidth(10)
public class EmployeeContractExportVO implements Serializable {

	private static final long serialVersionUID = 1L;

	@Schema(description = "申请编号")
	@ExcelProperty("申请编号")
	private String applyNo;

	@ExcelProperty("员工编码")
	@Length(max = 32, message = "员工编码不能超过32个字符")
	@ExcelAttribute(name = "员工编码", isNotEmpty = true, errorInfo = "员工编码不能为空", maxLength = 32)
	@Schema(description = "员工编码", name = "empNo")
	private String empNo;

	@ExcelProperty("员工姓名")
	@Length(max = 32, message = "员工姓名不能超过32个字符")
	@ExcelAttribute(name = "员工姓名", maxLength = 32, needExport = true)
	@Schema(description = "员工姓名", name = "empName")
	private String empName;

	@ExcelProperty("身份证号")
	@Length(max = 32, message = "身份证号不能超过32个字符")
	@ExcelAttribute(name = "身份证号", maxLength = 32, isIdCard = true, needExport = true)
	@Schema(description = "身份证号", name = "empIdcard")
	private String empIdcard;

	@ExcelProperty("合同起始日期")
	@NotBlank(message = "合同起始日期不能为空")
	@ExcelAttribute(name = "合同起始日期", isNotEmpty = true, errorInfo = "合同起始日期不能为空")
	@Schema(description = "合同起始日期", name = "contractStart")
	private String contractStart;

	@ExcelProperty("合同截止日期")
	@ExcelAttribute(name = "合同截止日期", needExport = true)
	@Schema(description = "合同截止日期", name = "contractEnd")
	private String contractEnd;

	@ExcelProperty("档案-省")
	@ExcelAttribute(name = "档案-省", maxLength = 32, isArea = true)
	@Schema(description = "档案-省", name = "fileProvince")
	private String fileProvince;

	@ExcelProperty("档案-市")
	@ExcelAttribute(name = "档案-市", maxLength = 32, isArea = true, parentField = "fileProvince")
	@Schema(description = "档案-市", name = "fileCity")
	private String fileCity;

	@ExcelProperty("档案-县")
	@ExcelAttribute(name = "档案-县", maxLength = 32, isArea = true, parentField = "fileCity")
	@Schema(description = "档案-县", name = "fileTown")
	private String fileTown;

	@ExcelProperty("项目名称")
	@Length(max = 128, message = "项目名称不能超过128个字符")
	@ExcelAttribute(name = "项目名称", maxLength = 128)
	@Schema(description = "项目名称", name = "subjectDepart")
	private String subjectDepart;

	@ExcelProperty("项目编码")
	@Schema(description = "项目编码")
	private String deptNo;

	@ExcelProperty("员工类型")
	@ExcelAttribute(name = "员工类型", isDataId = true, dataType = ExcelAttributeConstants.EMP_NATRUE)
	@Schema(description = "员工类型（字典值，0外包1派遣2代理）")
	private String empNatrue;

	@ExcelProperty("合同类型")
	@NotBlank(message = "合同类型不能为空")
	@Length(max = 32, message = "合同类型不能超过32个字符")
	@ExcelAttribute(name = "合同类型", isNotEmpty = true, errorInfo = "合同类型不能为空", maxLength = 32, needExport = true)
	@Schema(description = "合同类型", name = "contractName")
	private String contractName;

	@ExcelProperty("业务细分")
	@NotBlank(message = "业务细分不能为空")
	@Length(max = 32, message = "业务细分不能超过32个字符")
	@ExcelAttribute(name = "业务细分", maxLength = 32, needExport = true)
	@Schema(description = "业务细分", name = "contractName")
	private String contractSubName;

	@ExcelProperty("签订类型")
	@NotBlank(message = "签订类型不能为空")
	@Length(max = 1, message = "签订类型不能超过1个字符")
	@ExcelAttribute(name = "签订类型", isNotEmpty = true, errorInfo = "签订类型不能为空", maxLength = 100, isDataId = true, dataType = ExcelAttributeConstants.EMPLOYEE_SITUATION_TYPE)
	@Schema(description = "签订类型", name = "situation")
	private String situation;

	/**
	 * 签订期限employee_contract_type
	 * 0	已完成一定工作任务为期限
	 * 1	固定期限
	 * 2	无固定期限
	 */
	@ExcelProperty("签订期限")
	@NotBlank(message = "签订期限不能为空")
	@Length(max = 32, message = "签订期限不能超过32个字符")
	@ExcelAttribute(name = "签订期限", isNotEmpty = true, errorInfo = "签订期限不能为空", maxLength = 32, isDataId = true, dataType = ExcelAttributeConstants.EMPLOYEE_CONTRACT_TYPE, needExport = true)
	@Schema(description = "签订期限", name = "contractType")
	private String contractType;

	@ExcelProperty("合同甲方")
	@ExcelAttribute(name = "合同甲方")
	@Schema(description = "合同甲方")
	@Size(max = 50, message = "合同甲方不可超过50位")
	private String contractParty;

	@ExcelProperty("客户名称")
	@Length(max = 128, message = "客户名称不能超过128个字符")
	@ExcelAttribute(name = "客户名称", maxLength = 128)
	@Schema(description = "客户名称", name = "subjectUnit")
	private String subjectUnit;

	@ExcelProperty("审核状态")
	@ExcelAttribute(name = "审核状态", readConverterExp = "0=待提交,1=待审核,2=审核通过,3=审核不通过")
	@Schema(description = "审核状态")
	private String auditStatus;

	@ExcelProperty("合同状态")
	@ExcelAttribute(name = "合同状态", readConverterExp = "0=可用,1=不可用")
	@Schema(description = "合同状态", name = "inUse")
	private String inUse;

	@ExcelProperty("附件状态")
	@ExcelAttribute(name = "附件状态")
	@Schema(description = "附件状态", name = "isFile")
	private String files;

	@ExcelProperty("归档状态")
	@ExcelAttribute(name = "归档状态", readConverterExp = "0=已归档,1=未归档")
	@Schema(description = "归档状态", name = "isFile")
	private String isFile;

	@ExcelProperty("创建人")
	private String createName;

	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
	@ExcelProperty("创建时间")
	private String createTime;

	@ExcelProperty("累计签订次数")
	private String createNum;

	@ExcelProperty("首签日期")
	private String startDate;

	@ExcelProperty("最晚到期日期")
	private String endDate;

	@ExcelProperty("历次记录")
	private String history;

	@TableField(exist = false)
	@Schema(description = "选中的idList")
	private List<String> idList;

	@TableField(exist = false)
	@Schema(description = "导出的表头的Set")
	private Set<String> exportFields;

}
