/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import lombok.Data;

import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * 人员档案表-批量减档
 *
 * @author hgw
 * @date 2022-6-24 16:04:53
 */
@Data
@ColumnWidth(30)
public class EmployeeLeaveVO extends RowIndex implements Serializable {

	private static final long serialVersionUID = 1L;

	@ExcelProperty(value = "员工姓名")
	@Size(max = 20, message = "员工姓名不可超过20位")
	private String empName;

	@ExcelProperty(value = "身份证号")
	@Size(max = 20, message = "身份证号不可超过20位")
	private String empIdcard;

	@ExcelProperty(value = "减档原因")
	@Size(max = 32, message = "减档原因不可超过32位")
	@ExcelAttribute(name = "减档原因", isDataId = true,dataType = ExcelAttributeConstants.DOWNSHIFT_REASON)
	private String leaveReason;

	@ExcelProperty(value = "减档备注")
	@Size(max = 255, message = "减档原因不可超过255位")
	private String leaveRemark;

}
