/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Past;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Date;

/**
 * 项目档案表excel对应的实体
 *
 * @author huyc
 * @date 2022-06-20 17:54:40
 */
@Data
@ColumnWidth(30)
public class EmployeeProjectVO extends RowIndex implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 员工类型（字典值，0外包1派遣2代理）
     */
	@NotNull(message = "员工类型不能为空")
	@ExcelAttribute(name = "员工类型",isNotEmpty = true, errorInfo = "员工类型不能为空",maxLength = 2,isDataId = true,dataType = ExcelAttributeConstants.EMP_NATRUE)
	@ExcelProperty(value ="员工类型")
    private String empNatrue;

    /**
     * 员工姓名
     */
	@NotNull(message = "员工姓名不能为空")
	@ExcelAttribute(name = "员工姓名",isNotEmpty = true, errorInfo = "员工姓名不能为空",maxLength = 20)
	@ExcelProperty(value ="员工姓名")
    private String empName;

    /**
     * 身份证号码
     */
	@NotNull(message = "身份证号不能为空")
	@ExcelAttribute(name = "身份证号",isNotEmpty = true, errorInfo = "身份证号不能为空",maxLength = 20)
	@ExcelProperty(value ="身份证号")
    private String empIdcard;

    /**
     * 开户行
     */
	@ExcelProperty(value ="开户行")
    private String bankName;

    /**
     * 支行
     */
	@ExcelProperty(value ="支行")
    private String bankSubName;

    /**
     * 银行卡号
     */
	@ExcelProperty(value ="银行卡号")
    private String bankNo;

    /**
     * 项目编码
     */
	@NotNull(message = "项目编码不能为空")
	@ExcelProperty(value ="项目编码")
	@ExcelAttribute(name = "项目编码",isNotEmpty = true, errorInfo = "项目编码不能为空",maxLength = 20)
    private String deptNo;

    /**
     * 合同类型（字典值）
     */
	@NotNull(message = "合同类型不能为空")
	@ExcelProperty(value ="合同类型")
	@ExcelAttribute(name = "合同类型",isNotEmpty = true, errorInfo = "合同类型不能为空",maxLength = 10,isDataId = true,dataType = ExcelAttributeConstants.PERSONNEL_TYPE)
    private String contractType;

    /**
     * 工时制
     */
	@ExcelProperty(value ="工时制")
	@ExcelAttribute(name = "工时制",maxLength = 10,isDataId = true,dataType = ExcelAttributeConstants.WORKING_HOURS)
    private String workingHours;

    /**
     * 就职岗位
     */
	@NotNull(message = "就职岗位不能为空")
	@ExcelProperty(value ="就职岗位")
	@ExcelAttribute(name = "就职岗位",isNotEmpty = true, errorInfo = "就职岗位不能为空",maxLength = 20)
    private String post;

    /**
     * 入职日期
     */
	@ExcelProperty(value ="入职日期")
	@Past
	@DateTimeFormat("yyyy-MM-dd")
    private Date enjoinDate;

    /**
     * 试用期（单位月）
     */
	@ExcelProperty(value ="试用期")
	@ExcelAttribute(name = "试用期",maxLength = 4)
    private String tryPeriod;

}
