/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 项目档案表excel对应的实体
 *
 * @author huyc
 * @date 2022-06-20 17:54:40
 */
@Data
@ColumnWidth(30)
public class EmployeeXProjectVO extends RowIndex implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 员工姓名
     */
	@NotNull(message = "员工姓名不能为空")
	@ExcelAttribute(name = "员工姓名",isNotEmpty = true, errorInfo = "员工姓名不能为空",maxLength = 20)
	@ExcelProperty(value ="员工姓名")
    private String empName;

    /**
     * 身份证号码
     */
	@NotNull(message = "身份证号不能为空")
	@ExcelAttribute(name = "身份证号",isNotEmpty = true, errorInfo = "身份证号不能为空",maxLength = 20)
	@ExcelProperty(value ="身份证号")
    private String empIdcard;

    /**
     * 项目编码
     */
	@NotNull(message = "项目编码不能为空")
	@ExcelProperty(value ="项目编码")
	@ExcelAttribute(name = "项目编码",isNotEmpty = true, errorInfo = "项目编码不能为空",maxLength = 20)
    private String deptNo;

    /**
     * 减项原因
     */
	@ExcelProperty(value ="减项原因")
	@NotNull(message = "减项原因不能为空")
	@ExcelAttribute(name = "减项原因",isNotEmpty = true, errorInfo = "减项原因不能为空",maxLength = 100,isDataId = true,dataType = "reduce_project_reason")
    private String leaveReason;

	/**
	 * 减项备注
	 */
	@ExcelProperty(value ="减项备注")
	private String leaveRemark;

	/**
	 * 是否同步减档（0否；1是）
	 */
	@ExcelProperty(value ="是否同步减档")
//	@NotNull(message = "是否同步减档不能为空")
//	@ExcelAttribute(name = "是否同步减档",isNotEmpty = true, errorInfo = "是否同步减档不能为空",maxLength = 1)
	private String isLeaveEmployee;
}
