package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

/**
 * @Author fxj
 * @Date 2022/7/20
 * @Description 项目结算信息表：包含项目信息 和 客户信息
 * @Version 1.0
 */
@Data
public class ProjectSetInfoVo implements Serializable {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键")
	private String id;

	/**
	 * 结算主体编码
	 */
	@Schema(description = "结算主体编码")
	private String departNo;

	/**
	 * 结算主体名称
	 */
	@Schema(description = "结算主体名称")
	private String departName;

	/**
	 * 所属客户
	 */
	@Schema(description = "所属客户")
	private String customerId;

	/**
	 * 客户名称
	 */
	@Schema(description = "客户名称")
	private String customerName;

	/**
	 * 客户编码
	 */
	@Schema(description = "客户编码")
	private String customerCode;

	/**
	 * 商险结算类型：0预估  1 实缴
	 */
	@Schema(description = "商险结算类型")
	private String insuranceSettleType = CommonConstants.ONE_STRING;


}
