package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * @Author fxj
 * @Date 2022/6/27
 * @Description
 * @Version 1.0
 */
@Data
public class TCertRecordVo implements Serializable {

	/**
	 * 员工ID
	 */
	@ExcelAttribute(name = "员工ID" )
	@Schema(description ="员工ID")
	private String empId;

	/**
	 * 员工姓名
	 */
	@ExcelAttribute(name = "员工姓名" )
	@Schema(description ="员工姓名")
	private String empName;

	/**
	 * 员工身份证
	 */
	@ExcelAttribute(name = "员工身份证" )
	@Schema(description ="员工身份证")
	private String empIdcard;

	/**
	 * 项目名称
	 */
	@ExcelAttribute(name = "项目名称" )
	@Schema(description ="项目名称")
	private String projectName;

	/**
	 * 项目编码
	 */
	@ExcelAttribute(name = "项目编码" )
	@Schema(description ="项目编码")
	private String projectCode;

	/**
	 * 岗位
	 */
	@ExcelAttribute(name = "岗位" )
	@Schema(description ="岗位")
	private String post;

	/**
	 * 合同开始时间
	 */
	@ExcelAttribute(name = "合同开始时间" )
	@Schema(description ="合同开始时间")
	private LocalDateTime contractStart;

	/**
	 * 合同截止时间
	 */
	@ExcelAttribute(name = "合同截止时间" )
	@Schema(description ="合同截止时间")
	private LocalDateTime contractEnd;

	/**
	 * 开具当天时间
	 */
	@ExcelAttribute(name = "开具当天时间" )
	@Schema(description ="开具当天时间")
	private LocalDateTime openCurTime;

	/**
	 * 印章名称
	 */
	@ExcelAttribute(name = "印章名称" )
	@Schema(description ="印章名称")
	private String seal;

	/**
	 * 创建者
	 */
	@ExcelAttribute(name = "创建者" )
	@Schema(description ="创建者")
	private String createBy;

	/**
	 * 更新人
	 */
	@ExcelAttribute(name = "更新人" )
	@Schema(description ="更新人")
	private String updateBy;

	/**
	 * 创建人姓名
	 */
	@ExcelAttribute(name = "创建人姓名" )
	@Schema(description ="创建人姓名")
	private String createName;

	/**
	 * 创建时间
	 */
	@ExcelAttribute(name = "创建时间" )
	@Schema(description ="创建时间")
	private LocalDateTime createTime;

	/**
	 * 更新时间
	 */
	@ExcelAttribute(name = "更新时间" )
	@Schema(description ="更新时间")
	private LocalDateTime updateTime;

	/**
	 * 证明类型：0 在职 1 离职2劳动合同解除 3调档函4.代缴证明
	 */
	@ExcelAttribute(name = "证明类型：0 在职 1 离职2劳动合同解除 3调档函4.代缴证明" )
	@Schema(description ="证明类型：0 在职 1 离职2劳动合同解除 3调档函4.代缴证明")
	private String type;

	/**
	 * 离职时间
	 */
	@ExcelAttribute(name = "离职时间" )
	@Schema(description ="离职时间")
	private Date leaveTime;

	/**
	 * 派减原因
	 */
	@ExcelAttribute(name = "派减原因" )
	@Schema(description ="派减原因")
	private String leaveReason;

	/**
	 * 性别：0男 1女
	 */
	@ExcelAttribute(name = "性别：0男 1女" )
	@Schema(description ="性别：0男 1女")
	private String sex;

	/**
	 * 入职时间（来我单位时间）
	 */
	@ExcelAttribute(name = "入职时间（来我单位时间）" )
	@Schema(description ="入职时间（来我单位时间）")
	private LocalDateTime entryTime;

	/**
	 * 签订合同时间-第一次
	 */
	@ExcelAttribute(name = "签订合同时间-第一次" )
	@Schema(description ="签订合同时间-第一次")
	private LocalDateTime firstContractTime;

	/**
	 * 开具人
	 */
	@ExcelAttribute(name = "开具人" )
	@Schema(description ="开具人")
	private String opener;

	/**
	 * 开具时间
	 */
	@ExcelAttribute(name = "开具时间" )
	@Schema(description ="开具时间")
	private LocalDateTime openTime;

	/**
	 * 介绍单位
	 */
	@ExcelAttribute(name = "介绍单位" )
	@Schema(description ="介绍单位")
	private String introductionUnit;

	/**
	 * 参保时间
	 */
	@ExcelAttribute(name = "参保时间" )
	@Schema(description ="参保时间")
	private LocalDateTime socialTime;

}
