/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ValidityConstants;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 档案划转日志表
 *
 * @author huyc
 * @date 2022-06-22
 */
@Data
@ColumnWidth(30)
public class TEmpChangeInfoVO implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 员工姓名
     */
	@NotNull(message = "员工姓名不能为空")
	@ExcelAttribute(name = "员工姓名",isNotEmpty = true, errorInfo = "员工姓名不能为空",maxLength = 20)
	@ExcelProperty(value ="员工姓名")
    private String empName;

	/**
	 * 身份证号
	 */
	@NotNull(message = "身份证号不能为空")
	@ExcelAttribute(name = "身份证号",isNotEmpty = true, errorInfo = "身份证号不能为空",maxLength = 20)
	@ExcelProperty(value ="身份证号")
	private String empIdcard;

    /**
     * 原项目编码
     */
	@ExcelProperty(value ="原项目编码")
	@NotNull(message = "原项目编码不能为空")
	@ExcelAttribute(name = "原项目编码",isNotEmpty = true, errorInfo = "原项目编码不能为空",maxLength = 20)
    private String oldSettleCode;

    /**
     * 新项目编码
     */
	@ExcelProperty(value ="新项目编码")
	@NotNull(message = "新项目编码不能为空")
	@ExcelAttribute(name = "新项目编码",isNotEmpty = true, errorInfo = "新项目编码不能为空",maxLength = 20)
    private String newSettleCode;

    /**
     * 已产生未结算费用 0：划转 1：不划转
     */
	@ExcelProperty(value ="已产生未结算费用")
	@NotNull(message = "已产生未结算费用不能为空")
    private String unsettleDeal;

    /**
     * 划转起始月
     */
	@ExcelProperty(value ="划转起始月")
	@ExcelAttribute(name = "划转起始月",maxLength = 6, errorInfo = "划转起始月不能超过6位",isInteger = true)
    private String changeStartMonth;

}
