/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.pig4cloud.plugin.excel.annotation.RequestExcel;
import com.pig4cloud.plugin.excel.vo.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TCustomerInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmpChangeInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TSettleDomain;
import com.yifu.cloud.plus.v1.yifu.archives.service.TEmpChangeInfoService;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TEmpChangeInfoVO;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 档案划转日志表
 *
 * @author fxj
 * @date 2022-06-18 09:39:46
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tempchangeinfo" )
@Tag(name = "档案划转日志表管理")
public class TEmpChangeInfoController {

    private final TEmpChangeInfoService tEmpChangeInfoService;

    /**
     * 分页查询
     * @param page 分页对象
     * @param tEmpChangeInfo 档案划转日志表
     * @return
     */
    @Operation(summary = "分页查询", description = "分页查询")
    @GetMapping("/page" )
    @PreAuthorize("@pms.hasPermission('archives_tempchangeinfo_get')" )
    public R getTEmpChangeInfoPage(Page page, TEmpChangeInfo tEmpChangeInfo) {
        return R.ok(tEmpChangeInfoService.page(page, Wrappers.query(tEmpChangeInfo)));
    }


    /**
     * 通过id查询档案划转日志表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id查询", description = "通过id查询")
    @GetMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('archives_tempchangeinfo_get')" )
    public R getById(@PathVariable("id" ) Long id) {
        return R.ok(tEmpChangeInfoService.getById(id));
    }

    /**
     * 新增档案划转日志表
     * @param tEmpChangeInfo 档案划转日志表
     * @return R
     */
    @Operation(summary = "新增档案划转日志表", description = "新增档案划转日志表")
    @SysLog("新增档案划转日志表" )
    @PostMapping
    @PreAuthorize("@pms.hasPermission('archives_tempchangeinfo_add')" )
    public R save(@RequestBody TEmpChangeInfo tEmpChangeInfo) {
        return R.ok(tEmpChangeInfoService.save(tEmpChangeInfo));
    }

    /**
     * 修改档案划转日志表
     * @param tEmpChangeInfo 档案划转日志表
     * @return R
     */
    @Operation(summary = "修改档案划转日志表", description = "修改档案划转日志表")
    @SysLog("修改档案划转日志表" )
    @PutMapping
    @PreAuthorize("@pms.hasPermission('archives_tempchangeinfo_edit')" )
    public R updateById(@RequestBody TEmpChangeInfo tEmpChangeInfo) {
        return R.ok(tEmpChangeInfoService.updateById(tEmpChangeInfo));
    }

    /**
     * 通过id删除档案划转日志表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id删除档案划转日志表", description = "通过id删除档案划转日志表")
    @SysLog("通过id删除档案划转日志表" )
    @DeleteMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('archives_tempchangeinfo_del')" )
    public R removeById(@PathVariable Long id) {
        return R.ok(tEmpChangeInfoService.removeById(id));
    }

	/**
	 * 获取所有项目名称
	 * @return R
	 * @Author huyc
	 * @Date 2022-06-22
	 */
	@Operation(summary = "获取所有项目名称", description = "获取所有项目名称")
	@SysLog("获取所有项目名称" )
	@GetMapping("/getAllDept" )
	public R<List<TSettleDomain>> getAllDept() {
		return tEmpChangeInfoService.getAllDept();
	}


	/**
	 * 获取所有单位名称
	 * @return R
	 * @Author huyc
	 * @Date 2022-06-22
	 */
	@Operation(summary = "获取所有单位名称", description = "获取所有单位名称")
	@SysLog("获取所有单位名称" )
	@GetMapping("/getAllUint" )
	public R<List<TCustomerInfo>> getAllUint() {
		return tEmpChangeInfoService.getAllUint();
	}

	/**
	 * 员工档案划转
	 * @return R
	 * @Author huyc
	 * @Date 2022-06-22
	 */
	@Operation(summary = "员工档案划转", description = "员工档案划转")
	@SysLog("员工档案划转" )
	@PostMapping("/empProArcChange" )
	@PreAuthorize("@pms.hasPermission('archives_tempchangeinfo_change')")
	public R empProArcChange(@RequestBody TEmpChangeInfo tEmpChangeInfo) {
		return tEmpChangeInfoService.changeEmpProArc(tEmpChangeInfo);
	}

	/**
	 * 批量划转员工档案
	 * @return R
	 * @Author huyc
	 * @Date 2022-06-22
	 */
	@Operation(summary = "批量划转员工档案", description = "批量划转员工档案")
	@SysLog("批量划转员工档案" )
	@PostMapping("/batchChangeArc" )
	@PreAuthorize("@pms.hasPermission('archives_tempchangeinfo_batchchange')")
	public R<List<ErrorMessage>> batchChangeArc(@RequestExcel List<TEmpChangeInfoVO> excelVOList, BindingResult bindingResult) {
		return tEmpChangeInfoService.batchChangeArc(excelVOList,bindingResult);
	}

}
