/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeProject;
import com.yifu.cloud.plus.v1.yifu.archives.vo.EmployeeProjectExportVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 项目档案表
 *
 * @author huyc
 * @date 2022-06-20 09:19:40
 */
@Mapper
public interface TEmployeeProjectMapper extends BaseMapper<TEmployeeProject> {

	void updateExcelEmpProject(@Param("list") List<TEmployeeProject> list);

	int insertExcelEmpProject(@Param("list") List<TEmployeeProject> list);

	void updateEmpIdById(@Param("list") List<TEmployeeInfo> list);

	/**
	 * 通过部门编码获取最大员工编码
	 * @param deptNo
	 * @return
	 */
	String findEmployeeMaxOnlyNoByDepId(@Param("deptNo") String deptNo);

	IPage<TEmployeeProject> getTEmployeeProjectInfoPage(Page page, @Param("tEmployeeProject") TEmployeeProject tEmployeeProject);

	/**
	 * 获得导出的项目档案列表
	 * @param tEmployeeProject
	 * @return
	 */
	List<EmployeeProjectExportVO> getTEmployeeProjectExportPage(@Param("tEmployeeProject")EmployeeProjectExportVO tEmployeeProject);
}
