/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TSettleDomain;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TSettleDomainSelectVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.ProjectSetInfoVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 结算主体表
 *
 * @author hgw
 * @date 2022-06-20 10:02:28
 */
@Mapper
public interface TSettleDomainMapper extends BaseMapper<TSettleDomain> {

	/**
	 * @param id
	 * @Author: wangan
	 * @Date: 2019/10/18
	 * @Description: 通过id获取结算主体及单位部分信息
	 **/
	TSettleDomainSelectVo selectSettleDomainSelectVosById(@Param("id") String id);

	/**
	 * 获取所有客户单位的结算主体信息
	 * @Author fxj
	 * @Date 2019-12-24
	 * @param
	 * @return
	 **/
	List<TSettleDomainSelectVo> selectAllSettleDomainSelectVos();
	/**
	 * @Author fxj
	 * @Description  通过项目编码获取客户单位的结算主体信息
	 * @Date 11:08 2022/7/20
	 * @Param
	 * @return
	**/
    List<ProjectSetInfoVo> getSetInfoByCodes(@Param(value = "codes") List<String> codes);
}
