/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.service;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.fadada.api.exception.ApiException;
import com.yifu.cloud.plus.v1.yifu.archives.entity.FddSealInfo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;

import java.util.List;

/**
 * 法大大印章
 *
 * @author huyc
 * @date 2022-06-28 16:24:12
 */
public interface FddSealInfoService extends IService<FddSealInfo> {

	/**
	 * 法大大印章简单分页查询
	 * @param fddSealInfo 法大大印章
	 * @return
	 */
	List<FddSealInfo> getFddSealInfoPage(FddSealInfo fddSealInfo);

	/**
	 * 印章授权
	 * @param fddPersonAccountId 客服id
	 * @return
	 */
	R<String> sealAuth(List<String> id, String fddPersonAccountId) throws ApiException;

	/**
	 * 印章取消授权
	 * @param id
	 * @param fddPersonAccountId
	 * @return
	 */
	R<String> cancelSealAuth(List<String> id, String fddPersonAccountId) throws ApiException;

}
