package com.yifu.cloud.plus.v1.yifu.archives.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TCutsomerDataPermisson;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TCutsomerDataPermissonVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;

/**
 * 客户数据权限表
 *
 * @author pwang
 * @date 2019-07-19 10:39:28
 */
public interface TCutsomerDataPermissonService extends IService<TCutsomerDataPermisson> {

  /**
   * 客户数据权限表简单分页查询
   * @param tCutsomerDataPermisson 客户数据权限表
   * @return
   */
  IPage<TCutsomerDataPermissonVo> getTCutsomerDataPermissonPage(Page<TCutsomerDataPermissonVo> page, TCutsomerDataPermissonVo tCutsomerDataPermisson);
  /**
   * 查询数据所有者id
   * @Author pwang
   * @Date 2019-07-24 15:31
   * @param domainId 实体id
   * @param type 实体类型0：单位1：部门2：项目
   * @return 返回数据所有者的id串
   **/
  String findOwnerIdByIdAndType(String domainId,int type);
  /**
   * 查询数据所有者
   * @Author pwang
   * @Date 2019-07-24 15:31
   * @param domainId 实体id
   * @param type 实体类型0：单位1：部门2：项目
   * @return 返回数据所有者
   **/
  YifuUser findOwnerByIdAndType(String domainId, int type);

//  /**
//   * 获取当前登录人拥有的所有结算主体权限
//   * @Author fxj
//   * @Date 2019-08-26
//   * @param userId
//   * @return
//   **/
//  List<TCutsomerDataPermisson> selectAllSettleDomainPermissionByUserId(int userId);

  String getCustomerServiceByid(String id);
  /**
   * 获取所有有权限的用户
   * @Author pwang
   * @Date 2019-11-28 14:54
   * @param settleId
   * @return
   **/
  String getUserByid(String settleId);
   /**
    * 权限复制 将srcUserList里面的所有用户权限（表）赋给 beUser 所有人
    * @Author pwang
    * @Date 2020-03-20 17:50
    * @param srcUserList
    * @param beUser
    * @param user user授权人
    * @return
    **/
   R insertForCopyCutsomerDataPermisson(String[] srcUserList, String[] beUser, YifuUser user);
    /**
     * 专用方法 不建议调用 存在sql注入风险
     * @Author pwang
     * @Date 2020-07-02 19:00
     * @param sql
     * @param beUser
     * @param user
     * @return
     **/
    R insertCutsomerDataPermissonBySql(String sql, String beUser, YifuUser user);
}
