/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeContractInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeInfo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.EmployeeContractExportVO;
import com.yifu.cloud.plus.v1.yifu.archives.vo.EmployeeContractVO;
import com.yifu.cloud.plus.v1.yifu.archives.vo.ErrorMessageVO;
import com.yifu.cloud.plus.v1.yifu.archives.vo.ErrorVO;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import org.springframework.validation.BindingResult;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.List;

/**
 * 员工合同
 *
 * @author hgw
 * @date 2022-06-29 20:45:22
 */
public interface TEmployeeContractInfoService extends IService<TEmployeeContractInfo> {

	/**
	 * 员工合同信息表简单分页查询
	 *
	 * @param tEmployeeContractInfo 员工合同信息表
	 * @return
	 */
	IPage<TEmployeeContractInfo> getTEmployeeContractInfoPage(Page<TEmployeeContractInfo> page, TEmployeeContractInfo tEmployeeContractInfo);

	/**
	 * @param tEmployeeContractInfo
	 * @Description: list
	 * @Author: hgw
	 * @Date: 2022/7/4 20:32
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeContractInfo>
	 **/
	List<TEmployeeContractInfo> getTEmployeeContractList(TEmployeeContractInfo tEmployeeContractInfo);

	/**
	 * @param tEmployeeContractInfo
	 * @Description: 导出
	 * @Author: hgw
	 * @Date: 2022/7/4 20:32
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.archives.vo.EmployeeContractExportVO>
	 **/
	List<EmployeeContractExportVO> getTEmployeeContractExport(TEmployeeContractInfo tEmployeeContractInfo);

	/**
	 * @param tEmployeeContractInfo
	 * @Description: 导出历史合并
	 * @Author: hgw
	 * @Date: 2022/7/4 20:32
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.archives.vo.EmployeeContractExportVO>
	 **/
	List<EmployeeContractExportVO> getTEmployeeContractExportHistory(TEmployeeContractInfo tEmployeeContractInfo);

	/**
	 * @param tEmployeeContractInfo
	 * @Description: 新增
	 * @Author: hgw
	 * @Date: 2022/6/30 20:34
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.util.List < com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage>>
	 **/
	R<List<ErrorMessage>> saveNewContract(TEmployeeContractInfo tEmployeeContractInfo);

	/**
	 * @param tEmployeeContractInfo
	 * @Description: 编辑
	 * @Author: hgw
	 * @Date: 2022/6/30 20:34
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.util.List < com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage>>
	 **/
	R<List<ErrorMessage>> updateContract(TEmployeeContractInfo tEmployeeContractInfo);

	/**
	 * @param tEmployeeContractInfo
	 * @Description: 审核
	 * @Author: hgw
	 * @Date: 2022/7/1 10:23
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	R<String> auditContract(TEmployeeContractInfo tEmployeeContractInfo);

	/**
	 * @param id
	 * @Description: 单个删除
	 * @Author: hgw
	 * @Date: 2022/7/1 11:56
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	R<String> deleteContract(String id);

	/**
	 * @param idList
	 * @Description: 批量删除
	 * @Author: hgw
	 * @Date: 2022/7/1 11:40
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.util.List < com.yifu.cloud.plus.v1.yifu.archives.vo.ErrorMessageVO>>
	 **/
	R<List<ErrorVO>> batchDeleteContract(List<String> idList);

	/**
	 * @param tEmployeeContractInfo
	 * @Description: 归档
	 * @Author: hgw
	 * @Date: 2022/7/1 10:32
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.String>
	 **/
	R<String> filingContract(TEmployeeContractInfo tEmployeeContractInfo);

	/**
	 * @param inputStream
	 * @Description: 批量导入
	 * @Author: hgw
	 * @Date: 2022/7/4 17:16
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.util.List < com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage>>
	 **/
	R<List<ErrorMessage>> batchImport(InputStream inputStream);

	/**
	 * @param inputStream
	 * @Description: 批量更新
	 * @Author: hgw
	 * @Date: 2022/7/4 17:16
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.util.List < com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage>>
	 **/
	R<List<ErrorMessage>> batchUpdate(InputStream inputStream);

	/**
	 * @param contractInfo
	 * @Description: 批量导出员工合同
	 * @Author: hgw
	 * @Date: 2022-7-4 17:17:46
	 **/
	void exportContractInfo(TEmployeeContractInfo contractInfo, HttpServletResponse response);

	/**
	 * @param contractInfo
	 * @param response
	 * @Description: 批量导出员工合同[合并]
	 * @Author: hgw
	 * @Date: 2022/7/4 17:24
	 * @return: void
	 **/
	void exportContractInfoHistory(TEmployeeContractInfo contractInfo, HttpServletResponse response);

}
