package com.yifu.cloud.plus.v1.yifu.archives.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TAttaInfo;
import com.yifu.cloud.plus.v1.yifu.archives.mapper.TAttaInfoMapper;
import com.yifu.cloud.plus.v1.yifu.archives.service.TAttaInfoService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.OSSUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;

/**
 * 附件信息表
 *
 * @author pwang
 * @date 2021-02-19 16:16:07
 */
@Service
public class TAttaInfoServiceImpl extends ServiceImpl<TAttaInfoMapper, TAttaInfo> implements TAttaInfoService {

    @Autowired
    private OSSUtil ossUtil;

    /**
     * 附件信息表简单分页查询
     *
     * @param tAttaInfo 附件信息表
     * @return
     */
    @Override
    public IPage<TAttaInfo> getTAttaInfoPage(Page<TAttaInfo> page, TAttaInfo tAttaInfo) {
        return baseMapper.getTAttaInfoPage(page, tAttaInfo);
    }

    /**
     * @Author fxj
     * @Description
     * @Date 13:48 2022/6/17
     * @Param
     * @return
    **/
    @Override
    public List<TAttaInfo> getTAttaInfoList(TAttaInfo tAttaInfo) {
        return baseMapper.getTAttaInfoList(tAttaInfo);
    }

    @Override
    public TAttaInfo add(TAttaInfo attaInfo) {
        this.save(attaInfo);
        return attaInfo;
    }

	/**
	 * @Author fxj
	 * @Description
	 * @Date 13:48 2022/6/17
	 * @Param
	 * @return
	**/
    @Override
    public void update(List<TAttaInfo> attaInfoList, String domainId, String relationType) {
        if (attaInfoList != null) {
            for (TAttaInfo attaInfo : attaInfoList) {
                attaInfo.setDomainId(domainId);
                attaInfo.setRelationType(relationType);
                this.updateById(attaInfo);
            }
        }
    }

    /**
     * @Author fxj
     * @Description
     * @Date 13:48 2022/6/17
     * @Param
     * @return
    **/
    @Override
    public Boolean batchOssFileDelete(List<TAttaInfo> delAttaList) {
        try {
            for (TAttaInfo delAtta : delAttaList) {
                if (this.removeById(delAtta.getId())) {
                    ossUtil.deleteObject(null, delAtta.getAttaSrc());
                }
            }
            return true;
        } catch (Exception e) {
            log.error("附件删除异常：" + e.getMessage());
            return false;
        }
    }

    @Override
    public List<TAttaInfo> getKeenAtta(LocalDateTime dayStart, Collection<String> values) {
        return baseMapper.getKeenAtta(dayStart,values);
    }
	@Override
	public Boolean updateDomainId(String domainId, List<String> ids){
		if (Common.isEmpty(domainId) || !Common.isNotEmpty(ids)){
			return false;
		}
		return  baseMapper.updateDomainId(domainId,ids) > 0;
	}
}
