/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TCutsomerDataPermisson;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TSettleDomain;
import com.yifu.cloud.plus.v1.yifu.archives.mapper.TCutsomerDataPermissonMapper;
import com.yifu.cloud.plus.v1.yifu.archives.mapper.TSettleDomainMapper;
import com.yifu.cloud.plus.v1.yifu.archives.service.TSettleDomainService;
import com.yifu.cloud.plus.v1.yifu.archives.vo.ProjectSetInfoVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.SetInfoVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TSettleDomainSelectVo;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CacheConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.RedisUtil;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 结算主体表
 *
 * @author hgw
 * @date 2022-06-20 10:02:28
 */
@Service
@RequiredArgsConstructor
public class TSettleDomainServiceImpl extends ServiceImpl<TSettleDomainMapper, TSettleDomain> implements TSettleDomainService {
	@Autowired
	private RedisUtil redisUtil;

	private final TCutsomerDataPermissonMapper permissonMapper;
	/**
	 * @Author fxj
	 * @Description 清除结算主体缓存
	 * @Date 17:08 2022/7/11
	 * @Param
	 * @return
	**/
	@Override
	public void removeSettleCache(YifuUser user, List<String> userIdList) {
		try{
			for(String userId : userIdList){
				redisUtil.remove(CacheConstants.WXHR_SETTLE_DOMAIN_VOS_BY_USERID +"_"+userId);
			}
		} catch (Exception e) {
			log.error("清除缓存错误：",e);
		}
	}

	@Override
	public List<String> getSettleDomainIdsByUserId(String userId) {
		List<String> domainIds = new ArrayList<>();
		String userKey = CacheConstants.WXHR_SETTLE_DOMAIN_VOS_BY_USERID + "_" + userId;
		Object settleDomainVoR = redisUtil.get(userKey);
		if (settleDomainVoR != null) {
			return (List<String>) settleDomainVoR;
		} else {
			List<TCutsomerDataPermisson>  permissonList = permissonMapper.selectAllSettleDomainPermissionByUserId(Integer.parseInt(userId));
			if (Common.isNotNull(permissonList)) {
				domainIds = permissonList.stream().map(TCutsomerDataPermisson::getSettleDomainId).collect(Collectors.toList());
				redisUtil.set(userKey, domainIds);
			}
		}
		return domainIds;
	}

	/**
	 * @param id
	 * @Author: wangan
	 * @Date: 2019/10/18
	 * @Description: dataCheckDepart
	 * @return: com.yifu.cloud.v1.hrms.api.vo.TSettleDomainSelectVo
	 **/
	@Override
	public TSettleDomainSelectVo selectSettleDomainSelectVosById(String id) {
		return baseMapper.selectSettleDomainSelectVosById(id);
	}

	@Override
	public List<TSettleDomainSelectVo> selectAllSettleDomainSelectVos() {
		List<TSettleDomainSelectVo> sdList = baseMapper.selectAllSettleDomainSelectVos();
		return sdList;
	}

	@Override
	public SetInfoVo getSetInfoByCodes(List<String> codes) {
		List<ProjectSetInfoVo> voList = baseMapper.getSetInfoByCodes(codes);
		SetInfoVo setMap = new SetInfoVo();
		if (Common.isNotNull(voList)){
			setMap.setProjectSetInfoVoMap(voList.stream().collect(Collectors.toMap(k->k.getDepartNo(),k->k)));
		}
		return setMap;
	}
}
