/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.check.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.check.entity.TCheckBankNo;
import com.yifu.cloud.plus.v1.check.service.TCheckBankNoService;
import com.yifu.cloud.plus.v1.check.vo.CheckBankNoVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.http.HttpHeaders;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;


/**
 * 银行卡卡号 校验
 *
 * @author fxj
 * @date 2022-06-20 19:56:33
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tcheckbankno" )
@Tag(name = "银行卡卡号 校验管理")
public class TCheckBankNoController {

    private final TCheckBankNoService tCheckBankNoService;

    /**
     * 分页查询
     * @param page 分页对象
     * @param tCheckBankNo 银行卡卡号 校验
     * @return
     */
    @Operation(summary = "分页查询", description = "分页查询")
    @GetMapping("/page" )
    public R getTCheckBankNoPage(Page page, TCheckBankNo tCheckBankNo) {
        return R.ok(tCheckBankNoService.page(page, Wrappers.query(tCheckBankNo)));
    }


    /**
     * 通过id查询银行卡卡号 校验
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id查询", description = "通过id查询")
    @GetMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('demo_tcheckbankno_get')" )
    public R getById(@PathVariable("id" ) String id) {
        return R.ok(tCheckBankNoService.getById(id));
    }

    /**
     * 新增银行卡卡号 校验
     * @param tCheckBankNo 银行卡卡号 校验
     * @return R
     */
    @Operation(summary = "新增银行卡卡号 校验", description = "新增银行卡卡号 校验")
    @SysLog("新增银行卡卡号 校验" )
    @PostMapping
    @PreAuthorize("@pms.hasPermission('demo_tcheckbankno_add')" )
    public R save(@RequestBody TCheckBankNo tCheckBankNo) {
        return R.ok(tCheckBankNoService.save(tCheckBankNo));
    }

    /**
     * 修改银行卡卡号 校验
     * @param tCheckBankNo 银行卡卡号 校验
     * @return R
     */
    @Operation(summary = "修改银行卡卡号 校验", description = "修改银行卡卡号 校验")
    @SysLog("修改银行卡卡号 校验" )
    @PutMapping
    @PreAuthorize("@pms.hasPermission('demo_tcheckbankno_edit')" )
    public R updateById(@RequestBody TCheckBankNo tCheckBankNo) {
        return R.ok(tCheckBankNoService.updateById(tCheckBankNo));
    }

    /**
     * 通过id删除银行卡卡号 校验
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id删除银行卡卡号 校验", description = "通过id删除银行卡卡号 校验")
    @SysLog("通过id删除银行卡卡号 校验" )
    @DeleteMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('demo_tcheckbankno_del')" )
    public R removeById(@PathVariable String id) {
        return R.ok(tCheckBankNoService.removeById(id));
    }

	/**
	 * 银行卡号校验
	 * @param  checkBankNo	姓名	是	[string] 身份证号码，限单个	是	[string] 银行卡号，限单个	是	[string]银行预留手机号，仅支持国内11位号码
	 */
	@Operation(description = "银行卡号校验")
	@SysLog("银行卡号校验" )
	@Inner
	@PostMapping("/inner/checkBankNo" )
	public CheckBankNoVo checkBankNoInner(@RequestBody TCheckBankNo checkBankNo) {
		return tCheckBankNoService.checkBankNo(checkBankNo.getName(),checkBankNo.getIdNum(),checkBankNo.getBankNo(),checkBankNo.getMobile());
	}
}
