package com.yifu.cloud.plus.v1.check.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.check.entity.TCheckIdCard;
import com.yifu.cloud.plus.v1.check.service.TCheckIdCardService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.AllArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 身份证实名校验自留库
 *
 * @author fxj
 * @date 2022-05-11 16:12:18
 */
@RestController
@AllArgsConstructor
@RequestMapping("/tcheckidcard")
@Tag(name = "身份证实名校验自留库")
public class TCheckIdCardController {

     private final TCheckIdCardService tCheckIdCardService;

     /**
      * 简单分页查询
      *
      * @param page         分页对象
      * @param tCheckIdCard 身份证实名校验自留库
      * @return
      */
     @Operation(description = "简单分页查询")
     @GetMapping("/page")
     public R<IPage<TCheckIdCard>> getTCheckIdCardPage(Page<TCheckIdCard> page, TCheckIdCard tCheckIdCard) {
          return new R<>(tCheckIdCardService.getTCheckIdCardPage(page, tCheckIdCard));
     }

     @Operation(description = "获取所有list")
     @GetMapping("/getAllList")
     public R<List<TCheckIdCard>> getAllList(TCheckIdCard tCheckIdCard) {
          return new R<>(tCheckIdCardService.getAllList(tCheckIdCard));
     }

     /**
      * @param
      * @Description: 获取身份证库
      * @Author: hgw
      * @Date: 2022/5/11 17:44
      * @return: com.yifu.cloud.v1.common.core.util.R<java.util.Map < java.lang.String, com.yifu.cloud.v1.checks.api.entity.TCheckIdCard>>
      **/
     @Inner
     @Operation(description = "获取身份证库")
     @PostMapping("/inner/getAllChecksInfo")
     public R<Map<String, TCheckIdCard>> getAllChecksInfo() {
          return new R<>(new HashMap<>());
     }

     /**
      * 通过id查询单条记录
      *
      * @param id
      * @return R
      */
     @Operation(description = "id查询")
     @GetMapping("/{id}")
     public R<TCheckIdCard> getById(@PathVariable("id") String id) {
          return new R<>(tCheckIdCardService.getById(id));
     }

     /**
      * 新增记录
      *
      * @param tCheckIdCard
      * @return R
      */
     @Operation(description = "新增(checks:tcheckidcard_add)")
     @PostMapping
     @PreAuthorize("@pms.hasPermission('checks:tcheckidcard_add')")
     public R<Boolean> save(@Valid @RequestBody TCheckIdCard tCheckIdCard) {
          return new R<>(tCheckIdCardService.save(tCheckIdCard));
     }

     /**
      * 修改记录
      *
      * @param tCheckIdCard
      * @return R
      */
     @Operation(description = "修改(checks:tcheckidcard_edit)")
     @SysLog("修改身份证实名校验自留库")
     @PutMapping
     @PreAuthorize("@pms.hasPermission('checks:tcheckidcard_edit')")
     public R<Boolean> update(@RequestBody TCheckIdCard tCheckIdCard) {
          return new R(tCheckIdCardService.updateById(tCheckIdCard));
     }

     /**
      * 通过id删除一条记录
      *
      * @param id
      * @return R
      */
     @Operation(description = "删除(checks:tcheckidcard_del)")
     @SysLog("删除身份证实名校验自留库")
     @DeleteMapping("/{id}")
     @PreAuthorize("@pms.hasPermission('checks:tcheckidcard_del')")
     public R<Boolean> removeById(@PathVariable String id) {
          return new R<>(tCheckIdCardService.removeById(id));
     }

     /**
      * @param checkList
      * @Description: 校验姓名身份证
      * @Author: fxj
      * @Date: 2022-5-12 15:18:53
      * @return: com.yifu.cloud.v1.common.core.util.R
      **/
     @Operation(description = "校验姓名身份证")
     @SysLog("校验姓名身份证")
     @PostMapping("/checkIdCard")
     public R<List<TCheckIdCard>> checkIdCard(@RequestBody List<TCheckIdCard> checkList) {
          return tCheckIdCardService.checkIdCard(checkList);
     }

	/**
	 * @param checkList
	 * @Description: 校验姓名身份证
	 * @Author: fxj
	 * @Date: 2022-5-12 15:18:53
	 * @return: com.yifu.cloud.v1.common.core.util.R
	 **/
	@Operation(description = "校验姓名身份证")
	@SysLog("校验姓名身份证")
	@Inner
	@PostMapping("/inner/checkIdCard")
	public R<List<TCheckIdCard>> checkIdCardInner(@RequestBody List<TCheckIdCard> checkList) {
		return tCheckIdCardService.checkIdCard(checkList);
	}

	/**
	 * @Author fxj
	 * @Description  校验姓名身份证 --- 单个
	 * @Date 16:52 2022/6/22
	 * @Param
	 * @return
	**/
	@Operation(description = "校验姓名身份证 --- 单个")
	@SysLog("校验姓名身份证 --- 单个")
	@Inner
	@PostMapping("/inner/checkIdCardSingle")
	public TCheckIdCard checkIdCardSingle(@RequestBody TCheckIdCard tCheckIdCard) {
		return tCheckIdCardService.checkIdCardSingle(tCheckIdCard);
	}
}
