package com.yifu.cloud.plus.v1.check.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.check.entity.TCheckIdCard;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 身份证实名校验自留库
 *
 * @author hgw
 * @date 2022-05-11 16:12:18
 */
@Mapper
public interface TCheckIdCardMapper extends BaseMapper<TCheckIdCard> {
     /**
      * 身份证实名校验自留库简单分页查询
      *
      * @param tCheckIdCard 身份证实名校验自留库
      * @return
      */
     IPage<TCheckIdCard> getTCheckIdCardPage(Page<TCheckIdCard> page, @Param("tCheckIdCard") TCheckIdCard tCheckIdCard);

     /**
      * @param
      * @Description: 所有数据
      * @Author: hgw
      * @Date: 2022/5/12 15:28
      * @return: java.util.List<com.yifu.cloud.v1.checks.api.entity.TCheckIdCard>
      **/
     List<TCheckIdCard> getAllList(@Param("tCheckIdCard") TCheckIdCard tCheckIdCard);


}
