package com.yifu.cloud.plus.v1.check.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.check.entity.TCheckIdCard;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;

import java.util.List;
import java.util.Map;

/**
 * 身份证实名校验自留库
 *
 * @author hgw
 * @date 2022-05-11 16:12:18
 */
public interface TCheckIdCardService extends IService<TCheckIdCard> {

     /**
      * 身份证实名校验自留库简单分页查询
      *
      * @param tCheckIdCard 身份证实名校验自留库
      * @return
      */
     IPage<TCheckIdCard> getTCheckIdCardPage(Page<TCheckIdCard> page, TCheckIdCard tCheckIdCard);

     /**
      * @param
      * @Description: 获取所有list
      * @Author: hgw
      * @Date: 2022/5/12 15:29
      * @return: java.util.List<com.yifu.cloud.v1.checks.api.entity.TCheckIdCard>
      **/
     List<TCheckIdCard> getAllList(TCheckIdCard tCheckIdCard);

     Map<String, TCheckIdCard> getAllMap(TCheckIdCard tCheckIdCard);

     /**
      * @param checkList
      * @Description: 校验
      * @Author: hgw
      * @Date: 2022/5/12 15:20
      * @return: com.yifu.cloud.v1.common.core.util.R<java.lang.String>
      **/
     R<List<TCheckIdCard>> checkIdCard(List<TCheckIdCard> checkList);

    TCheckIdCard checkIdCardSingle(TCheckIdCard tCheckIdCard);
}
