/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.check.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.check.entity.TCheckBankNo;
import com.yifu.cloud.plus.v1.check.mapper.TCheckBankNoMapper;
import com.yifu.cloud.plus.v1.check.service.TCanCheckService;
import com.yifu.cloud.plus.v1.check.service.TCheckBankNoService;
import com.yifu.cloud.plus.v1.check.utils.ChecksUtil;
import com.yifu.cloud.plus.v1.check.vo.CheckBankNoVo;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.exception.ErrorCodes;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.MsgUtils;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

/**
 * 银行卡卡号 校验
 *
 * @author fxj
 * @date 2022-06-20 19:56:33
 */
@RequiredArgsConstructor
@Service
public class TCheckBankNoServiceImpl extends ServiceImpl<TCheckBankNoMapper, TCheckBankNo> implements TCheckBankNoService {

	private final TCanCheckService canCheckService;

	@Override
	public CheckBankNoVo checkBankNo(String name, String idNum, String cardNo, String mobile) {
		R<TCheckBankNo> res;
		CheckBankNoVo vo = new CheckBankNoVo();
		if (Common.isEmpty(name) || Common.isEmpty(idNum) || Common.isEmpty(cardNo)){
			vo.setRes(R.failed(MsgUtils.getMessage(ErrorCodes.CHECKS_BANK_NO_REQUEST_PARAM_ERROR)));
			return vo;
		}
		synchronized (this){
			TCheckBankNo  checkBankNo = baseMapper.selectOne(Wrappers.<TCheckBankNo>query().lambda()
					.eq(TCheckBankNo::getBankNo,cardNo)
					.eq(TCheckBankNo::getName,name)
					.eq(TCheckBankNo::getIdNum,idNum)
					.last(CommonConstants.LAST_ONE_SQL));
			if (Common.isNotNull(checkBankNo)){
				vo.setRes(R.ok(checkBankNo));
				return vo;
			}
			R<TCheckBankNo> resR = ChecksUtil.checkBankNo(name,idNum,cardNo,mobile,canCheckService.getCanCheck());
			if (Common.isNotNull(resR) && Common.isNotNull(resR.getData())){
				baseMapper.insert(resR.getData());
			}
			vo.setRes(resR);
			return vo;
		}
	}
}
