/*
 * Copyright (c) 2020 yifu4cloud Authors. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.yifu.cloud.plus.v1.yifu.common.core.constant;

/**
 * @author lengleng
 * @date 2020年01月01日
 * <p>
 * 缓存的key 常量
 */
public interface CacheConstants {

	/**
	 * oauth 缓存前缀
	 */
	String PROJECT_OAUTH_ACCESS = "yifu_oauth:access:";

	/**
	 * oauth 缓存令牌前缀
	 */
	String PROJECT_OAUTH_TOKEN = "yifu_oauth:token:";

	/**
	 * 验证码前缀
	 */
	String DEFAULT_CODE_KEY = "DEFAULT_CODE_KEY:";

	/**
	 * 菜单信息缓存
	 */
	String MENU_DETAILS = "menu_details";

	/**
	 * 用户信息缓存
	 */
	String USER_DETAILS = "user_details";

	/**
	 * 字典信息缓存
	 */
	String DICT_DETAILS = "dict_details";

	/**
	 * 字典项信息缓存
	 */
	String DICT_ITEM_DETAILS = "dict_item_details";

	/**
	 * oauth 客户端信息
	 */
	String CLIENT_DETAILS_KEY = "yifu_oauth:client:details";

	/**
	 * 参数缓存
	 */
	String PARAMS_DETAILS = "params_details";

	/**
	 * 数据权限信息缓存
	 * data_auth_details0：用户组
	 * data_auth_details1：用户
	 * hgw
	 * 2022-6-9 17:29:49
	 */
	String DATA_AUTH_DETAILS = "data_auth_details";

	/**
	 * @Description: 每日员工主码缓存
	 * @Author: hgw
	 * @Date: 2022/6/21 17:09
	 **/
	String EVERYDAY_EMP_CODE = "everyday_emp_code";
	/**
	 * @Description: 每日员工合同的 申请编码 缓存
	 * @Author: hgw
	 * @Date: 2022/6/21 17:09
	 **/
	String EVERYDAY_EMP_CONTRACT_CODE = "everyday_emp_contract_code";

	/**
	 * 区域数据--标签
	 */
	String AREA_LABEL = "area_label:";

	/**
	 * 区域数据--值
	 */
	String AREA_VALUE = "area_value:";
	/**
	 * 用户登录的结算主体vo缓存
	 */
	public static final String WXHR_SETTLE_DOMAIN_VOS_BY_USERID = ServiceNameConstants.ARCHIVES_SERVICE + "_SettleDomainVosByUserId";

}
