package com.yifu.cloud.plus.v1.yifu.common.core.constant;
/**
 * @author  fang
 * 常用的一些验证，如手机、移动号码、联通号码、电信号码、密码、座机、 邮政编码、邮箱、年龄、身份证、URL、QQ、汉字、字母、数字等校验表达式
 */
public class ValidityConstants {
    /** 工资-档案-手机号规则  */
    public static final String EMP_PHONE_PATTERN = "^1[3-9]\\d{9}$";
    /** 手机号规则 hgw2022-1-14 19:24:48客服刘岚有一个电信客户的手机号是16655125569故变更规则 */
    public static final String MOBILE_PATTERN="^(1[3-9][0-9])(\\d{8})$";
    /** 中国电信号码格式验证 手机段： 133,153,180,181,189,177,1700,173  **/
    public static final String CHINA_TELECOM_PATTERN = "(?:^(?:\\+86)?1(?:33|53|7[37]|8[019])\\d{8}$)|(?:^(?:\\+86)?1700\\d{7}$)";
    /** 中国联通号码格式验证 手机段：130,131,132,155,156,185,186,145,176,1707,1708,1709,175 **/
    public static final String CHINA_UNICOM_PATTERN = "(?:^(?:\\+86)?1(?:3[0-2]|4[5]|5[56]|7[56]|8[56])\\d{8}$)|(?:^(?:\\+86)?170[7-9]\\d{7}$)";
    /** 中国移动号码格式验证 手机段：134,135,136,137,138,139,150,151,152,157,158,159,182,183,184,187,188,147,178,1705 **/
    public static final String CHINA_MOVE_PATTERN = "(?:^(?:\\+86)?1(?:3[4-9]|4[7]|5[0-27-9]|7[8]|8[2-478])\\d{8}$)|(?:^(?:\\+86)?1705\\d{7}$)";
    /** 密码规则（6-16位字母、数字） */
    public static final String PASSWORD_PATTERN="^[0-9A-Za-z]{6,16}$";
    /** 固号（座机）规则 */
    public static final String LANDLINE_PATTERN="^(?:\\(\\d{3,4}\\)|\\d{3,4}-)?\\d{7,8}(?:-\\d{1,4})?$";
    /** 邮政编码规则 */
    public static final String POSTCODE_PATTERN = "[1-9]\\d{5}" ;
    /** 邮箱规则 */
    public static final String EMAIL_PATTERN = "^([a-z0-9A-Z]+[-|_|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$" ;
    /** 年龄规则 1-120之间  */
    public static final String AGE_PATTERN="^(?:[1-9][0-9]?|1[01][0-9]|120)$";
    /** 身份证规则 */
    public static final String IDCARD_PATTERN="(^[1-9]\\d{5}(18|19|20)\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$)|(^[1-9]\\d{5}\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}$)" ;
    /** URL规则，http、www、ftp */
    public static final String URL_PATTERN = "http(s)?://([\\w-]+\\.)+[\\w-]+(/[\\w- ./?%&=]*)?" ;
    /** QQ规则 */
    public static final String QQ_PATTERN = "^[1-9][0-9]{4,13}$" ;
    /** 全汉字规则 */
    public static final String CHINESE_PATTERN = "^[\u4E00-\u9FA5]+$" ;
    /** 全字母规则 */
    public static final String STR_ENG_PATTERN="^[A-Za-z]+$";
    /** 整数规则 */
    public static final String INTEGER_PATTERN = "^-?[0-9]+$" ;
    /** 正整数规则 */
    public static final String POSITIVE_INTEGER_PATTERN = "^\\+?[1-9][0-9]*$" ;
    /**浮点数规则*/
    public static final String FLOAT_PATTERN = "^(-?\\d+)(\\.\\d+)?$";

    /**日期格式化1*/
    public static final String DATEFORMAT1_PATTERN = "YYYY-MM-dd";

    /**日期格式化2*/
    public static final String DATEFORMAT2_PATTERN = "yyyy-MM-dd HH:mm:ss";

    /**日期格式化3*/
    public static final String DATEFORMAT3_PATTERN = "YYYY-MM";

	/**姓名规则 汉字、英文、· 最多10位*/
	public static final String USER_NAME_PATTERN = "^[\\u4e00-\\u9fa5a-zA-Z\\·]{1,10}";

	/** 全汉字 最多20位 规则 */
	public static final String CHINESE_PATTERN_20 = "^[\\u4E00-\\u9FA5]{1,20}";
}
