package com.yifu.cloud.plus.v1.yifu.common.core.util;


import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ValidityConstants;

import java.lang.reflect.Field;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExcelAttributeValidityUtil<T> {
	private Class<T> clazz;
	/**
	 * 用于返回错误信息
	 */
	private List<ErrorMessage> errorInfo;

	public ExcelAttributeValidityUtil(Class<T> clazz) {
		this.clazz = clazz;
	}

	public void ValidityObj(T obj) {
		List<ErrorMessage> errorList = new ArrayList<>();
		// 得到类的所有field
		Field[] allFields = clazz.getDeclaredFields();
		// 定义一个map用于存放列的序号和field
		Map<Integer, Field> fieldsMap = new HashMap<>();
		for (int i = 0, index = 0; i < allFields.length; i++) {
			Field field = allFields[i];
			// 将有注解的field存放到map中
			if (field.isAnnotationPresent(ExcelAttribute.class)) {
				// 设置类的私有字段属性可访问
				field.setAccessible(true);
				fieldsMap.put(index, field);
				index++;
			}
		}
		String error = "";
		String val = null;
		try {
			for (int j = 0; j < fieldsMap.size(); j++) {
				// 从map中得到对应列的field
				Field field = fieldsMap.get(j);
				//获取属性对应的注解属性
				ExcelAttribute attr = field.getAnnotation(ExcelAttribute.class);
				val = Common.getStringValByObject(Common.getFieldValueByName(field.getName(), obj));
				//校验字段是否符合要求
				error = ValidityFiled(val, attr);
				if (null != error) {
					errorList.add(new ErrorMessage(-1, error));
				}
			}
		} catch (Exception e) {
			errorList.add(new ErrorMessage(-1, e.getMessage()));
		}
		this.setErrorInfo(errorList);
	}

	private String ValidityFiled(String c, ExcelAttribute attr) {
		//非空校验
		if (attr.isNotEmpty() && Common.isEmpty(c)) {
			return (attr.name() + "_字段不可为空");
		}
		if (Common.isNotNull(c) && Common.isNotNull(c.trim())) {
			//日期格式校验
			if (attr.isDate()) {
				try {
					DateUtil.parseDate(c.trim(), attr.dateFormat());
				} catch (ParseException e) {
					return (Common.isEmpty(attr.errorInfo()) ? attr.name() + "_日期格式错误:" + attr.dateFormat() : attr.errorInfo());
				}
			}
			//手机号码校验
			if (attr.isPhone()) {
				if (!c.matches(Common.isEmpty(attr.pattern()) ? ValidityConstants.MOBILE_PATTERN : attr.pattern())) {
					return (Common.isEmpty(attr.errorInfo()) ? attr.name() + "_手机号码有误" : attr.errorInfo());
				}
			}
			//身份证校验
			if (attr.isIdCard()) {
				if (!c.matches(Common.isEmpty(attr.pattern()) ? ValidityConstants.IDCARD_PATTERN : attr.pattern())) {
					return (attr.name() + "_身份证格式有误");
				}
			}
			//邮箱验证
			if (attr.isEmail()) {
				if (!c.matches(Common.isEmpty(attr.pattern()) ? ValidityConstants.EMAIL_PATTERN : attr.pattern())) {
					return (Common.isEmpty(attr.errorInfo()) ? attr.name() + "_邮箱格式有误" : attr.errorInfo());
				}
			}
			//integer 验证
			if (attr.isInteger()) {
				if (!c.matches(Common.isEmpty(attr.pattern()) ? ValidityConstants.INTEGER_PATTERN : attr.pattern())) {
					return (Common.isEmpty(attr.errorInfo()) ? attr.name() + "_整数格式有误" : attr.errorInfo());
				}
			}
			//float、double 验证
			if (attr.isFloat()) {
				if (!c.matches(Common.isEmpty(attr.pattern()) ? ValidityConstants.FLOAT_PATTERN : attr.pattern())) {
					return (Common.isEmpty(attr.errorInfo()) ? attr.name() + "_数字格式有误" : attr.errorInfo());
				}
			}
		}
		return null;
	}

	public List<ErrorMessage> getErrorInfo() {
		return errorInfo;
	}

	public void setErrorInfo(List<ErrorMessage> errorInfo) {
		this.errorInfo = errorInfo;
	}
}
