/*
 * Copyright (c) 2020 yifu4cloud Authors. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.yifu.cloud.plus.v1.yifu.common.core.vo;

import lombok.Getter;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.User;

import java.util.Collection;

/**
 * @author lengleng
 * @date 2019/2/1 扩展用户信息
 */
public class YifuUser extends User {

	/**
	 * 用户ID
	 */
	@Getter
	private final String id;

	/**
	 * 部门ID
	 */
	@Getter
	private final Long deptId;

	/**
	 * 部门名称
	 */
	@Getter
	private final String deptName;

	/**
	 * 用户名称
	 */
	@Getter
	private String nickname;

	/**
	 * 手机号
	 */
	@Getter
	private final String phone;

	/**
	 * 是否是系统内置(0是，1否)
	 */
	@Getter
	private String systemFlag;

	/**
	 * 用户组
	 */
	@Getter
	private final String userGroup;

	public YifuUser(String id, Long deptId,String deptName, String username, String nickname,String systemFlag, String password, String phone, boolean enabled,
                    boolean accountNonExpired, boolean credentialsNonExpired, boolean accountNonLocked,String userGroup,
                    Collection<? extends GrantedAuthority> authorities) {
		super(username, password, enabled, accountNonExpired, credentialsNonExpired, accountNonLocked, authorities);
		this.id = id;
		this.deptId = deptId;
		this.deptName = deptName;
		this.phone = phone;
		this.nickname = nickname;
		this.systemFlag = systemFlag;
		this.userGroup = userGroup;
	}

}
