package com.yifu.cloud.plus.v1.yifu.common.dapr.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeContractInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeProject;
import com.yifu.cloud.plus.v1.yifu.archives.vo.*;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.SecurityConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.dapr.config.DaprArchivesProperties;
import lombok.extern.log4j.Log4j2;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author fxj
 * @Date 2022/7/11
 * @Description
 * @Version 1.0
 */
@Log4j2
@EnableConfigurationProperties(DaprArchivesProperties.class)
public class ArchivesDaprUtil {
	@Autowired
	private DaprArchivesProperties daprArchivesProperties;
	/**
	 * @Author fxj
	 * @Description  获取登录用户对应的计算主体权限
	 * @Date 21:15 2022/7/18
	 * @Param
	 * @return
	**/
	public R<List<String>> 	getSettleDomainIdsByUserId(){
		R<List<String>> res = HttpDaprUtil.invokeMethodGet(daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId(),"/tsettledomain/getSettleDomainIdsByUserId","", Object.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("获取用户项目权限失败！");
		}
		return res;
	}
	/**
	 * @Author fxj
	 * @Description 获取派单校验需要的档案信息
	 * @Date 21:18 2022/7/18
	 * @Param
	 * @return
	**/
	public R<Map<String, DispatchEmpVo>> getDispatchEmpVo(DispatchCheckVo checkVo){
		R<Map> res = HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId(),"/temployeeinfo/getDispatchEmpVo" , JSON.toJSONString(checkVo), Map.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("获取档案派单信息失败！");
		}
		Map<String,DispatchEmpVo> map  = JSON.parseObject(JSON.toJSONString(res.getData()),new TypeReference<HashMap<String,DispatchEmpVo>>(){});
		return R.ok(map);
	}
	/**
	 * @Author fxj
	 * @Description 通过结算主体编码获取结算主体及客户信息
	 * @Date 21:18 2022/7/20
	 * @Param
	 * @return
	 **/
	public R<SetInfoVo> getSetInfoByCodes(List<String> codes){
		R<SetInfoVo> res = HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId(),"/tsettledomain/getSetInfoByCodes",JSON.toJSONString(codes), SetInfoVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("获取档案派单信息失败！");
		}
		return res;
	}

	/**
	 * @Author fxj
	 * @Description 获取派单校验需要的档案信息
	 * @Date 21:18 2022/7/18
	 * @Param
	 * @return
	 **/
	public R<TSettleDomainSelectVo> getSettleDomainSelectVoById(String departId){
		R<TSettleDomainSelectVo> res = HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId(),"/tsettledomain/getSettleDomainSelectVoById",departId, Map.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("获取派单校验需要的档案信息失败！");
		}
		return res;
	}

	/**
	 * @Author fxj
	 * @Description 获取所有客户单位的结算主体信息
	 * @Date 21:18 2022/7/18
	 * @Param
	 * @return
	 **/
	public R<List<TSettleDomainSelectVo>> selectAllSettleDomainSelectVos(){
		R<List<TSettleDomainSelectVo>> res = HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId(),"/tsettledomain/getSettleDomainSelectVoById","", Map.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("获取所有客户单位的结算主体信息失败！");
		}
		return res;
	}

	public R<EmpDispatchAddVo> addDispatchInfo(EmpDispatchAddVo addVo) {
		R<EmpDispatchAddVo> res = HttpDaprUtil.invokeMethodPost(daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId(),"/temployeeinfo/addDispatchInfo" , JSON.toJSONString(addVo), EmpDispatchAddVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("新增档案|项目档案|合同信息失败！");
		}
		return res;
	}

	/**
	 * @param empId
	 * @Description: 获取档案基本信息
	 * @Author: hgw
	 * @Date: 2022/7/21 14:48
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeInfo>
	 **/
	public R<TEmployeeInfo> getTEmployeeInfoById(String empId) {
		R<TEmployeeInfo> res = HttpDaprUtil.invokeMethodPost(
				daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId()
				,"/temployeeinfo/inner/getByEmpId" , empId, TEmployeeInfo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("获取档案信息失败！");
		}
		return res;
	}

	/**
	 * @Description: 获取项目档案基本信息
	 * @Author: hgw
	 * @Date: 2022/7/21 14:48
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeInfo>
	 **/
	public R<TEmployeeProject> getTEmployeeProjectById(TEmployeeProject employeeProject) {
		R<TEmployeeProject> res = HttpDaprUtil.invokeMethodPost(
				daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId()
				,"/temployeeproject/inner/getByEmpIdAndDeptId" , JSON.toJSONString(employeeProject), TEmployeeProject.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("获取档案信息失败！");
		}
		return res;
	}

	/**
	 * @param id
	 * @Description: 获取档案合同
	 * @Author: fxj
	 * @Date: 2022/7/25 10:38
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeInfo>
	 **/
	public R<TEmployeeContractInfo> getContractById(String id) {
		R<TEmployeeContractInfo> res = HttpDaprUtil.invokeMethodPost(
				daprArchivesProperties.getAppUrl(),daprArchivesProperties.getAppId()
				,"/temployeeinfo/inner/getContractById" , id, TEmployeeContractInfo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("获取档案信息失败！");
		}
		return res;
	}
}
