package com.yifu.cloud.plus.v1.yifu.common.dapr.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.yifu.cloud.plus.v1.check.entity.TCheckIdCard;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeContractInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeProject;
import com.yifu.cloud.plus.v1.yifu.archives.vo.*;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.SecurityConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.dapr.config.DaprArchivesProperties;
import com.yifu.cloud.plus.v1.yifu.common.dapr.config.DaprCheckProperties;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author fxj
 * @Date 2022/7/11
 * @Description
 * @Version 1.0
 */
@Log4j2
@EnableConfigurationProperties(DaprCheckProperties.class)
public class CheckDaprUtil {
	@Autowired
	private DaprCheckProperties daprCheckProperties;
	/**
	 * @Author fxj
	 * @Description  身份证&姓名一致性校验
	 * @Date 21:15 2022/7/18
	 * @Param
	 * @return
	**/
	public R<TCheckIdCard> 	checkIdCardSingle(TCheckIdCard tCheckIdCard){
		R<TCheckIdCard> res = HttpDaprUtil.invokeMethodPost(daprCheckProperties.getAppUrl(),daprCheckProperties.getAppId(),"/tcheckidcard/inner/checkIdCardSingle",JSON.toJSONString(tCheckIdCard), TCheckIdCard.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(res)){
			return R.failed("校验身份证信息失败！");
		}
		return res;
	}

}
