package com.yifu.cloud.plus.v1.yifu.common.dapr.util;

import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysArea;
import com.yifu.cloud.plus.v1.yifu.admin.api.vo.AreaVo;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.SecurityConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.dapr.config.DaprArchivesProperties;
import com.yifu.cloud.plus.v1.yifu.common.dapr.config.DaprUpmsProperties;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

import java.util.List;

/**
 * @Author huyc
 * @Date 2022-07-18
 * @Description
 * @Version 1.0
 */
@Log4j2
@EnableConfigurationProperties(DaprUpmsProperties.class)
public class UpmsDaprUtils {

	@Autowired
	private DaprUpmsProperties daprUpmsProperties;

	/**
	 * 获取所有区域数据
	 * @Author huyc
	 * @Date 2022-07-18
	 * @return
	 **/
	public R<AreaVo> getAreaListR() {
		R<AreaVo> areaListR = HttpDaprUtil.invokeMethodPost(daprUpmsProperties.getAppUrl(),daprUpmsProperties.getAppId(),"/area/inner/getAreaVo","", AreaVo.class, SecurityConstants.FROM_IN);
		if (Common.isEmpty(areaListR)){
			return R.failed("获取所有区域数据失败！");
		}
		return areaListR;
	}
}
