package com.yifu.cloud.plus.v1.yifu.insurances.constants;

/**
 * @author licancan
 * @description 商险常量
 * @date 2022-07-18 17:52:59
 */
public class InsurancesConstants {

	/**
	 * 新增
	 */
	public static final String ADD = "新增";
	/**
	 * 批增
	 */
	public static final String BATCH = "批增";
	/**
	 * 替换
	 */
	public static final String REPLACE = "替换";
	/**
	 * 删除
	 */
	public static final String DELETE = "删除";
	/**
	 * 编辑
	 */
	public static final String EDIT = "编辑";
	/**
	 * 导出办理
	 */
	public static final String EXPORT = "导出办理";
	/**
	 * 投保退回
	 */
	public static final String ROLLBACK = "投保退回";
	/**
	 * 办理成功
	 */
	public static final String SUCCESSFUL = "办理成功";
	/**
	 * 登记保单保费
	 */
	public static final String REGISTERED = "登记保单保费";
	/**
	 * 新增投保成功
	 */
	public static final String ADD_SUCCESS = "新增投保成功";
	/**
	 * 批增投保成功
	 */
	public static final String BATCH_SUCCESS = "批增投保成功";
	/**
	 * 替换成功
	 */
	public static final String REPLACE_SUCCESS = "替换成功";
	/**
	 * 操作成功
	 */
	public static final String OPERATE_SUCCESS = "操作成功";
	/**
	 * 非投保退回状态，无法删除
	 */
	public static final String DELETE_ERROR = "非投保退回状态，无法删除";

	/**
	 * 不允许编辑
	 */
	public static final String EDIT_NOT_ALLOW = "不允许编辑";
	/**
	 * 投保信息已存在
	 */
	public static final String DATA_IS_EXIST = "投保信息已存在";
	/**
	 * 投保信息不存在
	 */
	public static final String DATA_IS_NOT_EXIST = "投保信息不存在";
	/**
	 * 被替换信息不存在
	 */
	public static final String REPLACE_IS_NOT_EXIST = "被替换信息不存在";
	/**
	 * 项目编码不存在
	 */
	public static final String DEPT_NO_IS_NOT_EXIST = "项目编码不存在";
	/**
	 * 未找到结算主体的结算方式
	 */
	public static final String PROJECT_NOT_FIND_SETTLE_TYPE = "未找到结算主体的结算方式";
	/**
	 * 替换者信息已存在
	 */
	public static final String REPLACE_IS_EXIST = "替换者信息已存在";
	/**
	 * 无效、已过期、已出险、已减员的 不能替换
	 */
	public static final String REPLACE_IS_NOT_ALLOW = "无效、已过期、已出险、已减员的 不能替换";
	/**
	 * 员工姓名不能为空
	 */
	public static final String EMP_NAME_NOT_EMPTY = "员工姓名不能为空";
	/**
	 * 替换员工姓名不能为空
	 */
	public static final String REPLACE_EMP_NAME_NOT_EMPTY = "替换员工姓名不能为空";
	/**
	 * 员工身份证号不能为空
	 */
	public static final String EMP_IDCARD_NO_NOT_EMPTY = "员工身份证号不能为空";
	/**
	 * 替换员工身份证号不能为空
	 */
	public static final String REPLACE_EMP_IDCARD_NO_NOT_EMPTY = "替换员工身份证号不能为空";
	/**
	 * 员工身份证号格式有误
	 */
	public static final String EMP_IDCARD_NO_NOT_LEGITIMATE = "员工身份证号格式有误";
	/**
	 * 员工姓名、身份证号不一致
	 */
	public static final String EMP_ID_CARD_NO_NOT_FIT = "员工姓名、身份证号不一致";
	/**
	 * 替换员工姓名、身份证号不一致
	 */
	public static final String REPLACE_EMP_ID_CARD_NO_NOT_FIT = "替换员工姓名、身份证号不一致";
	/**
	 * 替换员工身份证号格式有误
	 */
	public static final String REPLACE_EMP_IDCARD_NO_NOT_LEGITIMATE = "替换员工身份证号格式有误";
	/**
	 * 项目编码不能为空
	 */
	public static final String DEPT_NO_NOT_EMPTY = "项目编码不能为空";
	/**
	 * 替换项目编码不能为空
	 */
	public static final String REPLACE_DEPT_NO_NOT_EMPTY = "替换项目编码不能为空";
	/**
	 * 保险公司名称不能为空
	 */
	public static final String INSURANCE_COMPANY_NAME_NOT_EMPTY = "保险公司名称不能为空";
	/**
	 * 保险公司不存在
	 */
	public static final String INSURANCE_COMPANY_NAME_NOT_EXIST = "保险公司不存在";
	/**
	 * 险种名称不能为空
	 */
	public static final String INSURANCE_TYPE_NAME_NOT_EMPTY = "险种名称不能为空";
	/**
	 * 险种不存在
	 */
	public static final String INSURANCE_TYPE_NAME_NOT_EXIST = "险种不存在";
	/**
	 * 保单开始时间不能为空
	 */
	public static final String POLICY_START_NOT_EMPTY = "保单开始时间不能为空";
	/**
	 * 保单开始时间格式错误
	 */
	public static final String POLICY_START_PARSE_ERROR = "保单开始时间格式错误";
	/**
	 * 保单开始时间不能小于派单时间
	 */
	public static final String POLICY_START_SHOULD_IS_FUTURE = "保单开始时间不能小于派单时间";
	/**
	 * 保单结束时间不能为空
	 */
	public static final String POLICY_END_NOT_EMPTY = "保单结束时间不能为空";
	/**
	 * 保单结束时间格式错误
	 */
	public static final String POLICY_END_PARSE_ERROR = "保单结束时间格式错误";
	/**
	 * 购买标准不能为空
	 */
	public static final String BUY_STANDARD_NOT_EMPTY = "购买标准不能为空";
	/**
	 * 购买标准不存在
	 */
	public static final String BUY_STANDARD_NOT_EXIST = "购买标准不存在";
	/**
	 * 商险购买地省名称不能为空
	 */
	public static final String INSURANCE_PROVINCE_NAME_NOT_EMPTY = "商险购买地省名称不能为空";
	/**
	 * 商险购买地省名称不存在
	 */
	public static final String INSURANCE_PROVINCE_NAME_NOT_EXIST = "商险购买地省名称不存在";
	/**
	 * 商险购买地市名称
	 */
	public static final String INSURANCE_CITY_NAME_NOT_EMPTY = "商险购买地市名称不能为空";
	/**
	 * 商险购买地市名称不存在
	 */
	public static final String INSURANCE_CITY_NAME_NOT_EXIST = "商险购买地市名称不存在";
	/**
	 * 商险办理省名称不能为空
	 */
	public static final String INSURANCE_HANDLE_PROVINCE_NAME_NOT_EMPTY = "商险办理省名称不能为空";
	/**
	 * 商险办理省名称不存在
	 */
	public static final String INSURANCE_HANDLE_PROVINCE_NAME_NOT_EXIST = "商险办理省名称不存在";
	/**
	 * 商险办理城市名称不能为空
	 */
	public static final String INSURANCE_HANDLE_CITY_NAME_NOT_EMPTY = "商险办理城市名称不能为空";
	/**
	 * 商险办理城市名称不存在
	 */
	public static final String INSURANCE_HANDLE_CITY_NAME_NOT_EXIST = "商险办理城市名称不存在";
	/**
	 * 结算月不能为空
	 */
	public static final String SETTLE_MONTH_NOT_EMPTY = "结算月不能为空";
	/**
	 * 结算月格式错误
	 */
	public static final String SETTLE_MONTH_PARSE_ERROR = "结算月格式错误";
	/**
	 * 结算月不能小于派单月
	 */
	public static final String SETTLE_MONTH_SHOULD_IS_FUTURE = "结算月不能小于派单月";
	/**
	 * 岗位不能为空
	 */
	public static final String POST_NOT_EMPTY = "岗位不能为空";
	/**
	 * 保单号不能为空
	 */
	public static final String POLICY_NO_EMPTY = "保单号不能为空";
	/**
	 * 保费不能为空
	 */
	public static final String ACTUAL_PREMIUM_NO_EMPTY = "保费不能为空";
	/**
	 * 保单号不存在
	 */
	public static final String POLICY_NO_EXIST= "保单号不存在";

	/***********************减员办理错误码********************************/

	/**
	 * 已被替换，不允许减员
	 */
	public static final String IS_EFFECT_ERROR = "已被替换，不允许减员";

	/**
	 * 已超出保单截止日期，不允许减员
	 */
	public static final String IS_OVERDUE_ERROR = "已超出保单截止日期，不允许减员";

	/**
	 * 已出险的，不允许减员
	 */
	public static final String IS_USE_ERROR = "已出险的，不允许减员";

	/**
	 * 非已投保状态，无法减员
	 */
	public static final String REFUND_ERROR = "非已投保状态，无法减员";

	/**
	 * 替换结算月份和原有结算月份相同
	 */
	public static final String SETTLE_MONTH_IDENTICAL = "替换结算月份和原有结算月份相同";

	/**
	 * 当前保单已处于减员流程，无法变更结算月
	 */
	public static final String SETTLE_MONTH_CHANGE_REDUCE_HANDLE_STATUS_ERROR = "当前保单已处于减员流程，无法变更结算月";

	/**
	 * 当前保单已结算，无法变更结算月
	 */
	public static final String SETTLE_MONTH_CHANGE_SETTLE_HANDLE_STATUS_ERROR = "当前保单已结算，无法变更结算月";

	/**
	 * 替换项目ID和原有项目ID相同
	 */
	public static final String DEPT_NO_IDENTICAL = "替换项目ID和原有项目ID相同";

	/**
	 * 重复数据
	 */
	public static final String DUPLICATE_DATA_ERROR = "重复数据";

	/**
	 * 当前变更结算月列表为空
	 */
	public static final String SETTLE_MONTH_CHANGE_LIST_IS_EMPTY ="当前变更结算月列表为空";

	/**
	 * 替换人员不允许变更结算月
	 */
	public static final String SETTLE_MONTH_CHANGE_IS_EFFECT_ERROR ="替换人员不允许变更结算月";

	/**
	 * 替换人员不允许变更所属项目
	 */
	public static final String DEPT_NO_CHANGE_IS_EFFECT_ERROR ="替换人员不允许变更所属项目";

	/**
	 * 当前保单已结算，无法变更所属项目
	 */
	public static final String DEPT_NO_CHANGE_SETTLE_HANDLE_STATUS_ERROR = "当前保单已结算，无法变更所属项目";

}
