package com.yifu.cloud.plus.v1.yifu.insurances.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NonNull;
import org.checkerframework.common.value.qual.StringVal;

import javax.validation.constraints.NotBlank;


/**
 * 保险公司表
 *
 * @author zhaji
 * @return {@link null}
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_insurance_company")
@Tag(name = "保险公司表")
public class TInsuranceCompany extends BaseEntity {
    /**
     * 保险公司id
     */
	@Schema(description = "保险公司id")
	@TableId(type = IdType.ASSIGN_ID)
    private String id;

    /**
     * 保险公司名称
     */
	@NotBlank(message = "保险公司名称不能为空")
	@Schema(description = "保险公司名称")
    private String companyName;

    /**
     * 保险公司地址
     */
	@NotBlank(message = "保险公司地址不能为空")
	@Schema(description = "保险公司地址")
    private String companyAddress;

    /**
     * 对接人
     */
	@NotBlank(message = "对接人不能为空")
	@Schema(description = "对接人")
    private String companyDocking;

	/**
	 * 计费方式
	 */
	@NotBlank(message = "计费方式不能为空")
	@StringVal({"0","1"})
	@Schema(description = "计费方式(0：按天，1：按月)")
	private String billingType;

    /**
     * 删除标志(0：未删除，1：删除)
     */
	@Schema(description = "是否删除 0否/1是")
    private Integer deleteFlag;

}