package com.yifu.cloud.plus.v1.yifu.insurances.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;


/**
 * @author licancan
 * @description 商险明细表 t_insurance_detail
 * @date 2022-07-18 16:20:16
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_insurance_detail")
@Schema(description = "商险明细表")
public class TInsuranceDetail extends BaseEntity {
    /**
     * 主键
     */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键")
    private String id;

    /**
     * 员工姓名
     */
	@Schema(description = "员工姓名")
    private String empName;

    /**
     * 员工身份证号
     */
	@Schema(description = "员工身份证号")
    private String empIdcardNo;

	/**
	 * 项目编码
	 */
	@Schema(description = "项目编码")
    private String deptNo;

	/**
	 * 投保岗位
	 */
	@Schema(description = "投保岗位")
	private String post;

    /**
     * 保险公司名称(冗余字段)
     */
	@Schema(description = "保险公司名称")
    private String insuranceCompanyName;

    /**
     * 险种名称
     */
	@Schema(description = "险种名称")
    private String insuranceTypeName;

	/**
	 * 险种主键
	 */
	@Schema(description = "险种主键")
    private Long insuranceTypeId;

    /**
     * 购买标准
     */
	@Schema(description = "购买标准")
    private String buyStandard;

	/**
	 * 医疗额度
	 */
	@Schema(description = "医疗额度")
	private String medicalQuota;

	/**
	 * 身故或残疾额度
	 */
	@Schema(description = "身故或残疾额度")
	private String dieDisableQuota;

    /**
     * 保单编号
     */
	@Schema(description = "保单编号")
    private String policyNo;

    /**
     * 保单开始时间
     */
	@Schema(description = "保单开始时间")
    private LocalDate policyStart;

    /**
     * 保单结束时间
     */
	@Schema(description = "保单结束时间")
    private LocalDate policyEnd;

    /**
     * 保单生效日期
     */
	@Schema(description = "保单生效日期")
    private LocalDate policyEffect;

    /**
     * 办理时间
     */
	@Schema(description = "办理时间")
    private LocalDateTime batchDate;

	/**
	 * 结算月
	 */
	@Schema(description = "结算月")
	private String settleMonth;

    /**
     * 发票号
     */
	@Schema(description = "发票号")
    private String invoiceNo;

    /**
     * 购买类型， 1新增、3批增、4替换
     */
	@Schema(description = " 购买类型， 1新增、3批增、4替换")
    private Integer buyType;

    /**
     * 商险购买地省code
     */
	@Schema(description = "商险购买地省code")
    private Integer insuranceProvince;

	/**
	 * 商险购买地省
	 */
	@Schema(description = "商险购买地省")
    private String insuranceProvinceName;

    /**
     * 商险购买地市code
     */
	@Schema(description = "商险购买地市code")
    private Integer insuranceCity;

	/**
	 * 商险购买地市
	 */
	@Schema(description = "商险购买地市")
    private String insuranceCityName;

    /**
     * 商险办理省code
     */
	@Schema(description = "商险办理省code")
    private Integer insuranceHandleProvince;

	/**
	 * 商险办理省
	 */
	@Schema(description = "商险办理省")
    private String insuranceHandleProvinceName;

    /**
     * 商险办理城市code
     */
	@Schema(description = "商险办理城市code")
    private Integer insuranceHandleCity;

	/**
	 * 商险办理城市
	 */
	@Schema(description = "商险办理城市")
    private String insuranceHandleCityName;

    /**
     * 结算类型 (0、与薪资合并结算 1、单独结算)
     */
	@Schema(description = "结算类型 (0、预估 1、实缴)")
    private Integer settleType;

    /**
     * 实际保费
     */
	@Schema(description = "实际保费")
    private BigDecimal actualPremium;

    /**
     * 预估保费
     */
	@Schema(description = "预估保费")
    private BigDecimal estimatePremium;

    /**
     * 投保办理状态 1待投保 2投保中 3已投保 4投保退回 5 已减员
     */
	@Schema(description = "投保办理状态 1待投保 2投保中 3已投保 4投保退回 5 已减员")
    private Integer buyHandleStatus;

	/**
	 * 默认结算信息id
	 */
	@Schema(description = "默认结算信息id")
	private Integer defaultSettleId;

    /**
     * 减员状态 1待减员 2减员中3减员退回
     */
	@Schema(description = "减员状态 1待减员 2减员中3减员退回")
    private Integer reduceHandleStatus;

    /**
     * 是否出险 0未出险 1已出险
     */
	@Schema(description = "是否出险 0未出险 1已出险")
    private Integer isUse;

    /**
     * 是否有效 0有效 1无效
     */
	@Schema(description = "是否有效 0有效 1无效")
    private Integer isEffect;

    /**
     * 是否过期 0未过期 1已过期
     */
	@Schema(description = "是否过期 0未过期 1已过期")
    private Integer isOverdue;

	/**
	 * 备注
	 */
	@Schema(description = "备注")
    private String remark;

    /**
     * 是否删除 0未删除/1删除
     */
	@Schema(description = "是否删除 0否/1是")
    private Integer deleteFlag;

    private static final long serialVersionUID = 1L;
}